package com.ngrob.android.bluemoon.core.data.repository

import com.ngrob.android.bluemoon.core.database.dao.SexDao
import com.ngrob.android.bluemoon.core.database.model.ContraceptiveEnum
import com.ngrob.android.bluemoon.core.database.model.ContraceptiveUse
import com.ngrob.android.bluemoon.core.database.model.Sex
import com.ngrob.android.bluemoon.core.database.model.SexType
import com.ngrob.android.bluemoon.core.database.model.SexWithContraceptives
import kotlinx.coroutines.flow.Flow
import java.time.Clock
import java.time.LocalDate
import java.time.LocalDateTime
import java.time.format.DateTimeFormatter
import javax.inject.Inject

class OfflineSexRepository @Inject constructor(
    private val sexDao: SexDao,
    private val clock: Clock
): SexRepository {
    override fun getSexWithContraceptivesOfDate(date: LocalDate): Flow<List<SexWithContraceptives>> {
        return sexDao.getSexWithContraceptivesOnDate(date.format(DateTimeFormatter.ISO_LOCAL_DATE))
    }

    override fun addSex(type: SexType, contraceptives: List<ContraceptiveEnum>, date: LocalDate) {
        val sexEntity = Sex(
            id= null,
            type = type,
            date = date.format(DateTimeFormatter.ISO_LOCAL_DATE),
            loggedAt = LocalDateTime.now(clock).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME),
        )
        val sexId =  sexDao.insertSex(sexEntity)
        contraceptives.forEach {
            sexDao.insertUsedContraceptives(
                ContraceptiveUse(
                    id = null,
                    usedOnSexId = sexId.toInt(),
                    contraceptive = it,
                )
            )
        }

    }

    override fun deleteSexById(id: Int) {
       sexDao.deleteSexById(id)
    }

    override fun deleteAllSex() {
        sexDao.deleteAllSex()
    }
}