package com.ngrob.android.bluemoon.core.data.repository

import com.ngrob.android.bluemoon.core.database.dao.PillDao
import com.ngrob.android.bluemoon.core.database.model.Pill
import kotlinx.coroutines.flow.Flow
import java.time.Clock
import java.time.LocalDate
import java.time.LocalDateTime
import java.time.format.DateTimeFormatter
import javax.inject.Inject

class OfflinePillRepository @Inject constructor(
    private val pillDao: PillDao,
    private val clock: Clock
) : PillRepository {
    override fun getPillOfDay(date: LocalDate): Flow<Pill?> {
        return pillDao.getPillOfDay(date.format(DateTimeFormatter.ISO_LOCAL_DATE))
    }

    override fun takePill(date: LocalDate, isSubstitute: Boolean) {
        val pillEntity = Pill(
            id = null,
            taken = true,
            isSubstitute = isSubstitute,
            date = date.format(DateTimeFormatter.ISO_LOCAL_DATE),
            loggedAt = LocalDateTime.now(clock).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME)
        )
        pillDao.insertPill(pillEntity)
    }

    override fun deleteAllPills() {
        pillDao.deleteAllPills()
    }

    override fun deletePillById(id: Int) {
        pillDao.deletePillById(id)
    }
}