package com.ngrob.android.bluemoon.core.data.repository

import com.ngrob.android.bluemoon.core.database.model.Bleeding
import com.ngrob.android.bluemoon.core.database.model.BleedingStrength
import kotlinx.coroutines.flow.Flow
import java.time.LocalDate
import java.time.YearMonth

interface BleedingRepository {
    fun getAllBleedingsOfMonth(month: YearMonth): Flow<List<LocalDate>>
    fun getAllBleedingDates(): Flow<List<LocalDate>>
    fun getBleedingEntryOfDay(day: LocalDate): Flow<Bleeding?>
    suspend fun addBleeding(strength: BleedingStrength, date: LocalDate)
    suspend fun updateBleeding(strength: BleedingStrength, date: LocalDate)
    suspend fun addBleedings(dates: List<LocalDate>)
    fun importBleedings(bleedings: List<Bleeding>)
    suspend fun deleteBleedings(dates: List<LocalDate>)
    suspend fun deleteBleedingById(id: Int)
    suspend fun deleteAllBleeding()
}