package com.ngrob.android.bluemoon.core.data.di

import com.ngrob.android.bluemoon.core.data.repository.BleedingRepository
import com.ngrob.android.bluemoon.core.data.repository.OfflineBleedingRepository
import com.ngrob.android.bluemoon.core.data.repository.OfflinePillRepository
import com.ngrob.android.bluemoon.core.data.repository.OfflineSexRepository
import com.ngrob.android.bluemoon.core.data.repository.OfflineUserDataRepository
import com.ngrob.android.bluemoon.core.data.repository.PillRepository
import com.ngrob.android.bluemoon.core.data.repository.SexRepository
import com.ngrob.android.bluemoon.core.data.repository.UserDataRepository
import dagger.Binds
import dagger.Module
import dagger.hilt.InstallIn
import dagger.hilt.components.SingletonComponent

@Module
@InstallIn(SingletonComponent::class)
interface DataModule {

    @Binds
    fun bindsBleedingRepository(
        bleedingRepository: OfflineBleedingRepository,
    ): BleedingRepository

    @Binds
    fun bindsSexRepository(
        sexRepository: OfflineSexRepository
    ): SexRepository

    @Binds
    fun bindsPillRepository(
        pillRepository: OfflinePillRepository
    ): PillRepository

    @Binds
    fun bindsUserDataRepository(
        userDataRepository: OfflineUserDataRepository
    ): UserDataRepository
}