package com.ngrob.android.bluemoon

import androidx.annotation.StringRes
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.outlined.Analytics
import androidx.compose.material.icons.outlined.DateRange
import androidx.compose.material.icons.outlined.Home
import androidx.compose.material.icons.outlined.Settings
import androidx.compose.ui.graphics.vector.ImageVector

sealed class BottomNavItem(
    val route: String,
    @StringRes val resourceId: Int,
    val icon: ImageVector,
    val label: String
) {
    object Dashboard : BottomNavItem("dashboard", R.string.dashboard, Icons.Outlined.Home, "Overview")
    object Calendar : BottomNavItem("calendar", R.string.calendar, Icons.Outlined.DateRange, "Calendar")
    object Statistics : BottomNavItem("statistics", R.string.statistics, Icons.Outlined.Analytics, "Statistics")
    object Settings : BottomNavItem("settings", R.string.settings, Icons.Outlined.Settings, "Settings")
}

sealed class Route(
    val route: String
){
    object AddSymptom: Route(route = "add_symptom")
    object EditPeriod: Route(route="edit_period")
}