package com.ngrob.android.bluemoon

import androidx.lifecycle.ViewModel
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.asStateFlow
import kotlinx.coroutines.flow.update
import java.time.Clock
import java.time.LocalDate
import javax.inject.Inject

data class MainActivityUiState(
    val selectedDay: LocalDate,
)

@HiltViewModel
class BluemoonAppViewModel @Inject constructor(
    clock: Clock
) : ViewModel() {
    private val _uiState = MutableStateFlow(MainActivityUiState(LocalDate.now(clock)))
    val uiState = _uiState.asStateFlow()

    fun selectDay(newDay: LocalDate) {
        _uiState.update { currentState ->
            currentState.copy(
                selectedDay = newDay,
            )
        }
    }
}