package com.ngrob.android.bluemoon

import android.Manifest

import androidx.compose.ui.test.assertIsDisplayed
import androidx.compose.ui.test.junit4.createAndroidComposeRule
import androidx.compose.ui.test.onNodeWithText
import androidx.compose.ui.test.performClick
import androidx.test.rule.GrantPermissionRule
import dagger.hilt.android.testing.HiltAndroidRule
import dagger.hilt.android.testing.HiltAndroidTest
import org.junit.Before
import org.junit.Rule
import org.junit.Test


@HiltAndroidTest
class LogPeriodOnDashboardTest {

    @get:Rule(order = 0)
    var hiltRule = HiltAndroidRule(this)


    @get:Rule(order = 1)
    val composeTestRule = createAndroidComposeRule<MainActivity>()

    @JvmField
    @Rule(order = 2)
    var runtimePermissionRule: GrantPermissionRule =
        GrantPermissionRule.grant(Manifest.permission.POST_NOTIFICATIONS)

    @Before
    fun setUp() {
        hiltRule.inject()
    }

    @Test
    fun onPeriodStartedClickedCycleDayCountToOne() {
        composeTestRule.onNodeWithText("Period started", ignoreCase = true)
            .assertIsDisplayed()
            .performClick()
        composeTestRule.onNodeWithText("1. \ncycle day", ignoreCase = true).assertIsDisplayed()
        composeTestRule.onNodeWithText("Period ended", ignoreCase = true).assertIsDisplayed()

    }
}