
    /**
    OsciPrime an Open Source Android Oscilloscope
    Copyright (C) 2012  Manuel Di Cerbo, Nexus-Computing GmbH Switzerland
    Copyright (C) 2012  Andreas Rudolf, Nexus-Computing GmbH Switzerland

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
    */

/* DO NOT EDIT THIS FILE - it is machine generated */
#include <jni.h>
#include <android/log.h>

#define  LOG_TAG    ">==< libcopy >==<"
#define  LOGE(...)  __android_log_print(ANDROID_LOG_ERROR,LOG_TAG,__VA_ARGS__)
#define MAX_PTS 10000

//oh dear, this is completly useless, java space seems faster, how embaracing ..
void JNICALL Java_ch_nexuscomputing_android_osciprimeics_OsciPrimeApplication_copy2Data
  (JNIEnv * env, jclass cls, jobject pathCh1, jobject pathCh2, jintArray ch1, jintArray ch2, jint len, jint points, jfloat width, jfloat attCh1, jfloat attCh2)
{

	unsigned int i = 0;
	
	signed int* _ch1 = (signed int*)(*env)->GetPrimitiveArrayCritical(env,ch1,0);
	signed int* _ch2 = (signed int*)(*env)->GetPrimitiveArrayCritical(env,ch2,0);
	
	jclass peerCls = (*env)->GetObjectClass(env, pathCh1);


	jmethodID resetMethod = (*env)->GetMethodID(env, peerCls, "reset","()V");
	if(resetMethod < 0){ LOGE("resetMethod");}
	jmethodID moveToMethod = (*env)->GetMethodID(env, peerCls, "moveTo","(FF)V");
	if(moveToMethod < 0){ LOGE("moveToMethod");}
	jmethodID lineToMethod = (*env)->GetMethodID(env, peerCls, "lineTo","(FF)V");
	if(lineToMethod < 0){ LOGE("lineToMethod");}

	(*env)->CallVoidMethod(env, pathCh1, resetMethod);
	(*env)->CallVoidMethod(env, pathCh2, resetMethod);
	
	jfloat x0 = -width/2;
	jfloat div = width/((float)points -1);
	
	for(i = 0; i < len-1; i++){
		jfloat x = x0 + i * div; 
		jfloat x2 = x0 + (i + 1) * div;
		(*env)->CallVoidMethod(env, pathCh1, moveToMethod, x, _ch1[i] * attCh1);
		(*env)->CallVoidMethod(env, pathCh2, moveToMethod, x, _ch2[i] * attCh2);
		(*env)->CallVoidMethod(env, pathCh1, lineToMethod, x2, _ch1[i+1] * attCh1);
		(*env)->CallVoidMethod(env, pathCh2, lineToMethod, x2, _ch2[i+1] * attCh2);
	}
	
	(*env)->CallVoidMethod(env, pathCh1, moveToMethod, x0, 0);
	(*env)->CallVoidMethod(env, pathCh2, moveToMethod, x0, 0);
	(*env)->CallVoidMethod(env, pathCh1, lineToMethod, -x0, 0);
	(*env)->CallVoidMethod(env, pathCh2, lineToMethod, -x0, 0);
	
	(*env)->ReleasePrimitiveArrayCritical(env,ch1,_ch1,0);
	(*env)->ReleasePrimitiveArrayCritical(env,ch2,_ch2,0);
}


void JNICALL Java_ch_nexuscomputing_android_osciprimeics_OsciPrimeApplication_copy2Points
	(JNIEnv * env, jclass cls,
	jintArray src1, jintArray src2,
	jfloatArray dst1, jfloatArray dst2,
	jint _len, jint points, jfloat width, jfloat attCh1, jfloat attCh2)
{
	
	unsigned int i = 0;
	unsigned int pts = points;
	unsigned int len = _len;
	
	signed int* ch1 = (signed int*)(*env)->GetPrimitiveArrayCritical(env,src1,0);
	signed int* ch2 = (signed int*)(*env)->GetPrimitiveArrayCritical(env,src2,0);
	
	float* fch1 = (float*)(*env)->GetPrimitiveArrayCritical(env,dst1,0);
	float* fch2 = (float*)(*env)->GetPrimitiveArrayCritical(env,dst2,0);
	
	if(len > MAX_PTS){
		LOGE("Length too high!");
		return;
	}
//	static jfloat fch1[4*MAX_PTS];
//	static jfloat fch2[4*MAX_PTS];
	
	float x0 = -width/2;
	float div = width/((float)pts -1);
	
	for(i = 0; i < len; i++){
		fch1[4*i] = x0 + i * div;
		fch1[4*i+1] = ch1[i] * attCh1;
		fch1[4*i+2] = x0 + (i + 1) * div;
		fch1[4*i+3] = ch1[i + 1]* attCh1;
		
		fch2[4*i] = x0 + i * div;
		fch2[4*i+1] = ch2[i] * attCh2;
		fch2[4*i+2] = x0 + (i + 1) * div;
		fch2[4*i+3] = ch2[i + 1]* attCh2;
	}
	
	unsigned int arrlen = (*env)->GetArrayLength(env, dst1);
	(*env)->ReleasePrimitiveArrayCritical(env,dst1,fch1,0);
	(*env)->ReleasePrimitiveArrayCritical(env,dst2,fch2,0);
//	(*env)->SetFloatArrayRegion(env, dst1, 0, arrlen, &fch1[0]);
//	(*env)->SetFloatArrayRegion(env, dst2, 0, arrlen, &fch2[0]);
	(*env)->ReleasePrimitiveArrayCritical(env,src1,ch1,0);
	(*env)->ReleasePrimitiveArrayCritical(env,src2,ch2,0);
}

/*
void JNICALL Java_ch_nexuscomputing_android_osciprimeics_OsciPrimeApplication_copy2Points
	(JNIEnv * env, jclass cls,
	jintArray src1, jintArray src2,
	jfloatArray dst1, jfloatArray dst2,
	jint len, jint points, jfloat width, jfloat attCh1, jfloat attCh2)
{
	
	unsigned int i = 0;
	
	
	signed int* ch1 = (signed int*)(*env)->GetPrimitiveArrayCritical(env,src1,0);
	signed int* ch2 = (signed int*)(*env)->GetPrimitiveArrayCritical(env,src2,0);
	
	float* fch1 = (float*)(*env)->GetPrimitiveArrayCritical(env,dst1,0);
	float* fch2 = (float*)(*env)->GetPrimitiveArrayCritical(env,dst2,0);
	
	float x0 = -width/2;
	float div = width/((float)points -1);
	
	for(i = 0; i < len; i++){
		fch1[4*i] = x0 + i * div;
		fch1[4*i+1] = ch1[i] * attCh1;
		fch1[4*i+2] = x0 + (i + 1) * div;
		fch1[4*i+3] = ch1[i + 1]* attCh1;
		
		fch2[4*i] = x0 + i * div;
		fch2[4*i+1] = ch2[i] * attCh2;
		fch2[4*i+2] = x0 + (i + 1) * div;
		fch2[4*i+3] = ch2[i + 1]* attCh2;
	}
	
	(*env)->ReleasePrimitiveArrayCritical(env,dst1,fch1,0);
	(*env)->ReleasePrimitiveArrayCritical(env,dst2,fch2,0);
	(*env)->ReleasePrimitiveArrayCritical(env,src1,ch1,0);
	(*env)->ReleasePrimitiveArrayCritical(env,src2,ch2,0);
}*/
