---
layout: default
title: Home
nav_order: 1
---

# BRouter: Let's get serious about bike routing

There's a lot of routing software on the market, both free and commercial, both
online and offline, both OSM and proprietary maps. However, when it comes to
bike routing, it's hard to find something that's really useful. There's far less
money and engineering power in the field compared to car navigation.

What do we expect from a bike routing software? It should be able to calculate
more or less the routes that match your experience in the regions you are
familiar with, thus giving you confidence that it yields the same quality in
unknown regions. Scanning the market with that expectation gives little to no
result.

Here's what makes BRouter unique:

- It uses [freely configurable routing profiles](features/costfunctions.md)
- It works [fully offline on any Android phone](features/offline.md) and is
  interfaced to some of the most popular Android map tools
- It uses a sophisticated [routing-algorithm](developers/algorithm.md) with
  [elevation consideration](features/elevation.md)
- It offers [alternative route calculations](features/alternatives.md)
- It supports [via and nogo-points](features/vianogo.md)
- It can [consider long distance cycle routes](features/cycleroutes.md)

Routing data is available worldwide with automatic weekly updates

### BRouter uses OpenStreetMap

BRouter uses user-generated, collaboratively collected free geodata. Thanks to
OpenStreetMap.org and contributors - please donate your geographic data to
openstreetmap.org! See the [License
description](http://www.openstreetmap.org/copyright) for details.

### Online versions

Check [brouter-web](/brouter-web) or [bikerouter.de](https://www.bikerouter.de/)
if you want to use BRouter online.

### Android app for offline routing

See [Android quickstart guide](users/android_quickstart.md) for how to setup BRouter for
offline routing on an Android smartphone.

### Revision history

See the [revision history](revisions.md) for older revisions of the app and the
change-log.

### Privacy Policy

Please see [privacy policy](privacy_policy.md)

### Google group for support questions and feedback

Please use the
[osm-android-bikerouting](http://groups.google.com/group/osm-android-bikerouting)
google group for any questions/feedback.

### Other bike routing resources:

* [OpenStreetMap wiki router comparison
  matrix](http://wiki.openstreetmap.org/wiki/Routing/online_routers)
* [OpenRouteService.org](http://www.openrouteservice.org)
* [Naviki.org](http://www.naviki.org)
* [yournavigation.org](http://www.yournavigation.org)
* [maps.cloudmade.com](http://maps.cloudmade.com)
* [graphhopper.com](http://graphhopper.com)
* [cycle.travel](http://cycle.travel/map)
