package bou.amine.apps.readerforselfossv2.utils

import android.text.format.DateUtils
import kotlinx.datetime.Clock

@Suppress("detekt:UtilityClassWithPublicConstructor")
actual class DateUtils {
    actual companion object {
        actual fun parseRelativeDate(dateString: String): String {
            val date = dateString.toParsedDate()

            return " " +
                DateUtils.getRelativeTimeSpanString(
                    date,
                    Clock.System.now().toEpochMilliseconds(),
                    DateUtils.MINUTE_IN_MILLIS,
                    DateUtils.FORMAT_ABBREV_RELATIVE,
                )
        }
    }
}
