package bou.amine.apps.readerforselfossv2.tests.repository

import bou.amine.apps.readerforselfossv2.dao.ITEM
import bou.amine.apps.readerforselfossv2.model.SelfossModel

fun generateTestDBItems(item: FakeItemParameters = FakeItemParameters()): List<ITEM> =
    listOf(
        ITEM(
            id = item.id,
            datetime = item.datetime,
            title = item.title,
            content = item.content,
            unread = item.unread,
            starred = item.starred,
            thumbnail = item.thumbnail,
            icon = item.icon,
            link = item.link,
            sourcetitle = item.sourcetitle,
            tags = item.tags,
            author = item.author,
        ),
    )

fun generateTestApiItem(item: FakeItemParameters = FakeItemParameters()): List<SelfossModel.Item> =
    listOf(
        SelfossModel.Item(
            id = item.id.toInt(),
            datetime = item.datetime,
            title = item.title,
            content = item.content,
            unread = item.unread,
            starred = item.starred,
            thumbnail = item.thumbnail,
            icon = item.icon,
            link = item.link,
            sourcetitle = item.sourcetitle,
            tags = item.tags.split(','),
            author = item.author,
        ),
    )

class FakeItemParameters {
    var id = "20"
    var datetime = "2022-09-09T03:32:01-04:00"
    val title = "Etica della ricerca sotto i riflettori."
    val content =
        "<p><strong>Luigi Campanella, già Presidente SCI</strong></p>\n<p>L’etica della scienza è di certo ambito di cui continuiamo a scoprire nuovi aspetti e risvolti.</p>\n<p>L’ultimo è quello delle intelligenze artificiali capaci di creare opere complesse basate su immagini e parole memorizzate con il rischio di fake news e di contenuti disturbanti.</p>\n<p>Per evitare che ciò accada si sta procedendo filtrando secondo criteri di autocensura i dati da cui l’intelligenza artificiale parte.</p>\n<p>Comincia ad intravedersi un futuro prossimo di competizione fra autori umani ed artificiali nel quale sarà importante, quando i loro prodotti saranno indistinguibili, dichiararne l’origine.</p>\n<p>Come si comprende, si conferma che gli aspetti etici dell’innovazione e della ricerca si diversificato sempre di più.</p>\n<p>La biologia molecolare e la genetica già in passato hanno posto all’attenzione comune aspetti di etica della scienza che hanno indotto a nuove riflessioni circa i limiti delle ricerche.</p>\n<p>L’argomento, sempre attuale, torna sulle prime pagine a seguito della pubblicazione di una ricerca della Università di Cambridge che ha sviluppato una struttura cellulare di un topo con un cuore che batte regolarmente.</p>\n<img src=\"https://ilblogdellasci.files.wordpress.com/2022/09/image002-1.png?w=481\" alt=\"\" width=\"697\" height=\"430\" /><img src=\"https://ilblogdellasci.files.wordpress.com/2022/09/image003-1.png?w=906\" alt=\"\" /><p>Magdalena Zernicka-Goetz</p>\n<img src=\"https://ilblogdellasci.files.wordpress.com/2022/09/image004.jpg?w=474\" alt=\"\" width=\"622\" height=\"465\" /><p>Gianluca Amadei</p>\n<p>Del gruppo fa parte anche uno scienziato italiano Gianluca Amadei,che dinnanzi alle obiezioni di natura etica sulla realizzazione della vita artificiale si è affrettato a sostenere che non è creare nuove vite il fine primario della ricerca, ma quello di salvare quelle esistenti, di dare contributi essenziali alla medicina citando il caso del fallimento tuttora non interpretato di alcune gravidanze e di superare la sperimentazione animale, così contribuendo positivamente alla soluzione di un altro dilemma etico.</p>\n<p>L’embrione sintetico ha ovviamente come primo traguardo il contributo ai trapianti oggi drammaticamente carenti nell’offerta rispetto alla domanda, con attese fino a 4 anni per i trapianti di cuore ed a 2 anni per quelli di fegato. Il lavoro dovrebbe adesso continuare presso l’Ateneo di Padova per creare nuovi organi e nuovi farmaci.</p>"
    var unread = true
    var starred = true
    val thumbnail = null
    val icon = "ba79e238383ce83c23a169929c8906ef.png"
    val link =
        "https://ilblogdellasci.wordpress.com/2022/09/09/etica-della-ricerca-sotto-i-riflettori/"
    var sourcetitle = "La Chimica e la Società"
    var tags = "Chimica, Testing"
    var author = "Someone important"
}
