package bou.amine.apps.readerforselfossv2.android.fragments

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import bou.amine.apps.readerforselfossv2.android.databinding.FragmentImageBinding
import bou.amine.apps.readerforselfossv2.android.utils.glide.bitmapWithCache
import bou.amine.apps.readerforselfossv2.service.AppSettingsService
import org.kodein.di.DI
import org.kodein.di.DIAware
import org.kodein.di.android.x.closestDI
import org.kodein.di.instance

class ImageFragment :
    Fragment(),
    DIAware {
    override val di: DI by closestDI()
    private val appSettingsService: AppSettingsService by instance()
    private lateinit var imageUrl: String
    private var _binding: FragmentImageBinding? = null
    val binding get() = _binding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        imageUrl = requireArguments().getString("imageUrl")!!
    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?,
    ): View? {
        _binding = FragmentImageBinding.inflate(inflater, container, false)
        val view = binding?.root

        binding!!.photoView.visibility = View.VISIBLE
        requireActivity().bitmapWithCache(imageUrl, binding!!.photoView, appSettingsService)

        return view
    }

    override fun onDestroyView() {
        super.onDestroyView()
        _binding = null
    }

    companion object {
        private const val ARG_IMAGE = "imageUrl"

        fun newInstance(imageUrl: String): ImageFragment {
            val fragment = ImageFragment()
            val args = Bundle()
            args.putString(ARG_IMAGE, imageUrl)
            fragment.arguments = args
            return fragment
        }
    }
}
