package bou.amine.apps.readerforselfossv2.android.adapters

import android.app.Activity
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import bou.amine.apps.readerforselfossv2.android.R
import bou.amine.apps.readerforselfossv2.android.databinding.ListItemBinding
import bou.amine.apps.readerforselfossv2.android.utils.LinkOnTouchListener
import bou.amine.apps.readerforselfossv2.android.utils.acra.sendSilentlyWithAcraWithName
import bou.amine.apps.readerforselfossv2.android.utils.glide.circularDrawable
import bou.amine.apps.readerforselfossv2.model.SelfossModel
import bou.amine.apps.readerforselfossv2.repository.Repository
import bou.amine.apps.readerforselfossv2.service.AppSettingsService
import bou.amine.apps.readerforselfossv2.utils.getHtmlDecoded
import bou.amine.apps.readerforselfossv2.utils.getIcon
import bou.amine.apps.readerforselfossv2.utils.getThumbnail
import org.kodein.di.DI
import org.kodein.di.android.closestDI
import org.kodein.di.instance

class ItemListAdapter(
    override val app: Activity,
    override var items: ArrayList<SelfossModel.Item>,
    override val updateHomeItems: (ArrayList<SelfossModel.Item>) -> Unit,
) : ItemsAdapter<ItemListAdapter.ViewHolder>() {
    override lateinit var binding: ListItemBinding

    override val di: DI by closestDI(app)
    override val repository: Repository by instance()
    override val appSettingsService: AppSettingsService by instance()

    override fun onCreateViewHolder(
        parent: ViewGroup,
        viewType: Int,
    ): ViewHolder {
        binding = ListItemBinding.inflate(LayoutInflater.from(parent.context), parent, false)
        return ViewHolder(binding)
    }

    override fun onBindViewHolder(
        holder: ViewHolder,
        position: Int,
    ) {
        with(holder) {
            val itm = items[position]

            handleLinkOpening(binding, position)

            binding.title.text = itm.title.getHtmlDecoded()

            binding.title.setOnTouchListener(LinkOnTouchListener())

            binding.title.setLinkTextColor(c.resources.getColor(R.color.colorAccent))

            binding.sourceTitleAndDate.text =
                try {
                    itm.sourceAuthorAndDate()
                } catch (e: Exception) {
                    e.sendSilentlyWithAcraWithName("ItemListAdapter parse date")
                    itm.sourceAuthorOnly()
                }

            if (itm.getThumbnail(repository.baseUrl).isEmpty()) {
                if (itm.getIcon(repository.baseUrl).isEmpty()) {
                    binding.itemImage.setBackgroundAndText(itm.sourcetitle.getHtmlDecoded())
                } else {
                    c.circularDrawable(itm.getIcon(repository.baseUrl), binding.itemImage, appSettingsService)
                }
            } else {
                c.circularDrawable(itm.getThumbnail(repository.baseUrl), binding.itemImage, appSettingsService)
            }
        }
    }

    inner class ViewHolder(
        val binding: ListItemBinding,
    ) : RecyclerView.ViewHolder(binding.root)
}
