package bou.amine.apps.readerforselfossv2.android

import androidx.test.espresso.AmbiguousViewMatcherException
import androidx.test.espresso.Espresso.onView
import androidx.test.espresso.IdlingRegistry
import androidx.test.espresso.action.ViewActions
import androidx.test.espresso.action.ViewActions.click
import androidx.test.espresso.action.ViewActions.swipeDown
import androidx.test.espresso.assertion.ViewAssertions.doesNotExist
import androidx.test.espresso.assertion.ViewAssertions.matches
import androidx.test.espresso.matcher.ViewMatchers.isDisplayed
import androidx.test.espresso.matcher.ViewMatchers.isRoot
import androidx.test.espresso.matcher.ViewMatchers.withId
import androidx.test.espresso.matcher.ViewMatchers.withText
import androidx.test.ext.junit.rules.ActivityScenarioRule
import androidx.test.ext.junit.runners.AndroidJUnit4
import androidx.test.filters.LargeTest
import bou.amine.apps.readerforselfossv2.android.testing.CountingIdlingResourceSingleton
import org.junit.After
import org.junit.Before
import org.junit.Rule
import org.junit.Test
import org.junit.runner.RunWith
import java.util.UUID

@Suppress("ktlint:standard:class-naming", "detekt:ClassNaming")
@RunWith(AndroidJUnit4::class)
@LargeTest
class `7-SourcesActivityTest` : WithANRException() {
    @get:Rule
    val activityRule = ActivityScenarioRule(HomeActivity::class.java)

    lateinit var sourceName: String

    @Before
    fun init() {
        IdlingRegistry
            .getInstance()
            .register(CountingIdlingResourceSingleton.countingIdlingResource)
        sourceName = UUID.randomUUID().toString().substring(0, 15)

        goToSources()
    }

    @Test
    fun addSource() {
        testAddSourceWithUrl(
            "https://lorem-rss.herokuapp.com/feed?unit=year&interval=1&length=10",
            sourceName,
        )
    }

    @Suppress("detekt:SwallowedException")
    @Test
    fun addSourceCheckContent() {
        testAddSourceWithUrl("https://news.google.com/rss?hl=en-US&gl=US&ceid=US:en", sourceName)
        onView(isRoot()).perform(ViewActions.pressBack())
        openMenu()
        onView(withText(R.string.menu_home_refresh)).perform(click())
        onView(withText(R.string.refresh_dialog_message)).check(matches(isDisplayed()))
        onView(
            withId(android.R.id.button1),
        ).perform(click())
        Thread.sleep(10000)
        onView(withId(R.id.swipeRefreshLayout)).perform(swipeDown())
        Thread.sleep(2000)
        try {
            onView(withId(R.id.sourceTitleAndDate)).check(matches(isDisplayed()))
        } catch (e: AmbiguousViewMatcherException) {
            assert(true)
        }
        goToSources()
    }

    @After
    fun deleteTheCreatedSource() {
        onView(withText(sourceName)).check(matches(isDisplayed()))
        onView(withId(R.id.deleteBtn)).perform(click())
        onView(withText(R.string.confirm_delete_title)).check(matches(isDisplayed()))
        onView(withId(android.R.id.button1)).perform(click())
        onView(withText(sourceName)).check(doesNotExist())
    }
}
