package bou.amine.apps.readerforselfossv2.repository

import bou.amine.apps.readerforselfossv2.utils.toParsedDate
import kotlinx.datetime.LocalDateTime
import kotlinx.datetime.TimeZone
import kotlinx.datetime.toInstant
import kotlin.test.Test
import kotlin.test.assertEquals

class DatesTest {
    private val newVersionDateVariant = "2022-12-24T17:00:08+00"
    private val newVersionDate = "2013-04-07T13:43:00+01:00"
    private val newVersionDate2 = "2013-04-07T13:43:00-01:00"
    private val oldVersionDate = "2013-05-07 13:46:00"
    private val oldVersionDateVariant = "2021-03-21 10:32:00.000000"

    @Test
    fun new_version_date_should_be_parsed() {
        val date = newVersionDate.toParsedDate()
        val expected =
            LocalDateTime(2013, 4, 7, 13, 43, 0, 0)
                .toInstant(TimeZone.currentSystemDefault())
                .toEpochMilliseconds()

        assertEquals(expected, date)
    }

    @Test
    fun new_version_date2_should_be_parsed() {
        val date = newVersionDate2.toParsedDate()
        val expected =
            LocalDateTime(2013, 4, 7, 13, 43, 0, 0)
                .toInstant(TimeZone.currentSystemDefault())
                .toEpochMilliseconds()

        assertEquals(expected, date)
    }

    @Test
    fun old_version_date_should_be_parsed() {
        val date = oldVersionDate.toParsedDate()
        val expected =
            LocalDateTime(2013, 5, 7, 13, 46, 0, 0)
                .toInstant(TimeZone.currentSystemDefault())
                .toEpochMilliseconds()

        assertEquals(expected, date)
    }

    @Test
    fun old_version_variant_date_should_be_parsed() {
        val date = oldVersionDateVariant.toParsedDate()
        val expected =
            LocalDateTime(2021, 3, 21, 10, 32, 0, 0)
                .toInstant(TimeZone.currentSystemDefault())
                .toEpochMilliseconds()

        assertEquals(expected, date)
    }

    @Test
    fun new_version_variant_date_should_be_parsed() {
        val date = newVersionDateVariant.toParsedDate()
        val expected =
            LocalDateTime(2022, 12, 24, 17, 0, 8, 0)
                .toInstant(TimeZone.currentSystemDefault())
                .toEpochMilliseconds()

        assertEquals(expected, date)
    }
}
