@file:Suppress("detekt:TooManyFunctions")

package bou.amine.apps.readerforselfossv2.service

import com.russhwolf.settings.Settings

// This will be used in ACRA process. For now, it does nothing.
// This is to fix ACRA not sending reports anymore.
// See https://www.acra.ch/docs/Troubleshooting-Guide#applicationoncreate
class ACRASettings : Settings {
    override val keys: MutableSet<String> = mutableSetOf()
    override val size: Int = 0

    val bools: MutableMap<String, Boolean> = mutableMapOf()
    val doubles: MutableMap<String, Double> = mutableMapOf()
    val floats: MutableMap<String, Float> = mutableMapOf()
    val ints: MutableMap<String, Int> = mutableMapOf()
    val longs: MutableMap<String, Long> = mutableMapOf()
    val strings: MutableMap<String, String> = mutableMapOf()

    override fun clear() {
        // Nothing
    }

    override fun getBoolean(
        key: String,
        defaultValue: Boolean,
    ): Boolean = bools[key] ?: defaultValue

    override fun getBooleanOrNull(key: String): Boolean? = bools[key]

    override fun getDouble(
        key: String,
        defaultValue: Double,
    ): Double = doubles[key] ?: defaultValue

    override fun getDoubleOrNull(key: String): Double? = doubles[key]

    override fun getFloat(
        key: String,
        defaultValue: Float,
    ): Float = floats[key] ?: defaultValue

    override fun getFloatOrNull(key: String): Float? = floats[key]

    override fun getInt(
        key: String,
        defaultValue: Int,
    ): Int = ints[key] ?: defaultValue

    override fun getIntOrNull(key: String): Int? = ints[key]

    override fun getLong(
        key: String,
        defaultValue: Long,
    ): Long = longs[key] ?: defaultValue

    override fun getLongOrNull(key: String): Long? = longs[key]

    override fun getString(
        key: String,
        defaultValue: String,
    ): String = strings[key] ?: defaultValue

    override fun getStringOrNull(key: String): String? = strings[key]

    override fun hasKey(key: String): Boolean = keys.contains(key)

    override fun putBoolean(
        key: String,
        value: Boolean,
    ) {
        keys.add(key)
        bools[key] = value
    }

    override fun putDouble(
        key: String,
        value: Double,
    ) {
        keys.add(key)
        doubles[key] = value
    }

    override fun putFloat(
        key: String,
        value: Float,
    ) {
        keys.add(key)
        floats[key] = value
    }

    override fun putInt(
        key: String,
        value: Int,
    ) {
        keys.add(key)
        ints[key] = value
    }

    override fun putLong(
        key: String,
        value: Long,
    ) {
        keys.add(key)
        longs[key] = value
    }

    override fun putString(
        key: String,
        value: String,
    ) {
        keys.add(key)
        strings[key] = value
    }

    override fun remove(key: String) {
        keys.remove(key)
        bools.remove(key)
        doubles.remove(key)
        floats.remove(key)
        ints.remove(key)
        longs.remove(key)
        strings.remove(key)
    }
}
