package bou.amine.apps.readerforselfossv2.android.utils.bottombar

import android.content.Context
import android.graphics.drawable.Drawable
import androidx.annotation.IdRes
import androidx.annotation.StringRes
import bou.amine.apps.readerforselfossv2.android.R
import com.ashokvarma.bottomnavigation.TextBadgeItem
import com.leinardi.android.speeddial.SpeedDialActionItem
import com.leinardi.android.speeddial.SpeedDialView

fun TextBadgeItem.removeBadge(): TextBadgeItem {
    this.setText("")
    this.hide()
    return this
}

fun TextBadgeItem.maybeShow(): TextBadgeItem = if (this.isHidden) this.show() else this

@Suppress("detekt:LongParameterList")
fun SpeedDialView.addHomeMadeActionItem(
    @IdRes actionId: Int,
    actionIcon: Drawable,
    @StringRes labelId: Int,
    colorOnSurface: Int,
    colorSurface: Int,
    context: Context,
) {
    this.addActionItem(
        SpeedDialActionItem
            .Builder(actionId, actionIcon)
            .setFabBackgroundColor(context.resources.getColor(R.color.colorAccent))
            .setFabImageTintColor(colorOnSurface)
            .setLabel(context.getString(labelId))
            .setLabelClickable(false)
            .setLabelBackgroundColor(colorOnSurface)
            .setLabelColor(colorSurface)
            .create(),
    )
}
