package bou.amine.apps.readerforselfossv2.android.utils.acra

import android.content.Context
import android.os.DeadSystemException
import com.google.auto.service.AutoService
import org.acra.builder.ReportBuilder
import org.acra.config.CoreConfiguration
import org.acra.config.ReportingAdministrator
import org.acra.data.CrashReportData

@AutoService(ReportingAdministrator::class)
class AcraReportingAdministrator : ReportingAdministrator {
    override fun shouldStartCollecting(
        context: Context,
        config: CoreConfiguration,
        reportBuilder: ReportBuilder,
    ): Boolean =
        reportBuilder.exception !is DeadSystemException &&
            (reportBuilder.exception != null && reportBuilder.exception!!::class.simpleName != "CannotDeliverBroadcastException")

    override fun shouldSendReport(
        context: Context,
        config: CoreConfiguration,
        crashReportData: CrashReportData,
    ): Boolean = crashReportData.get("BRAND") != "redroid" && !crashReportData.get("PHONE_MODEL").toString().startsWith("sdk_gphone")
}
