package bou.amine.apps.readerforselfossv2.android.utils

import android.content.Context
import android.content.Intent
import android.util.TypedValue
import androidx.annotation.AttrRes
import androidx.annotation.ColorInt
import androidx.fragment.app.Fragment
import bou.amine.apps.readerforselfossv2.android.R
import bou.amine.apps.readerforselfossv2.android.utils.acra.sendSilentlyWithAcraWithName
import bou.amine.apps.readerforselfossv2.utils.toStringUriWithHttp

fun Context.shareLink(
    itemUrl: String?,
    itemTitle: String,
) {
    if (itemUrl.isUrlValid()) {
        val sendIntent = Intent()
        sendIntent.flags = Intent.FLAG_ACTIVITY_NEW_TASK
        sendIntent.action = Intent.ACTION_SEND
        sendIntent.putExtra(Intent.EXTRA_TEXT, itemUrl!!.toStringUriWithHttp())
        sendIntent.putExtra(Intent.EXTRA_SUBJECT, itemTitle)
        sendIntent.type = "text/plain"
        startActivity(
            Intent
                .createChooser(
                    sendIntent,
                    getString(R.string.share),
                ).setFlags(Intent.FLAG_ACTIVITY_NEW_TASK),
        )
    }
}

@ColorInt
fun Fragment.getColorFromAttr(
    @AttrRes attrColor: Int,
    resolveRefs: Boolean = true,
): Int {
    val typedValue = TypedValue()
    maybeIfContextWithLog { this.requireContext().theme.resolveAttribute(attrColor, typedValue, resolveRefs) }
    return typedValue.data
}

@Suppress("detekt:SwallowedException")
fun Fragment.maybeIfContext(fn: (Context) -> Any): Any? {
    try {
        return fn(this.requireContext())
    } catch (e: Exception) {
        // Do nothing
        return null
    }
}

fun Fragment.maybeIfContextWithLog(fn: (Context) -> Any): Any? {
    try {
        return fn(this.requireContext())
    } catch (e: Exception) {
        e.sendSilentlyWithAcraWithName("Fragment context issue...")
        return null
    }
}
