package bou.amine.apps.readerforselfossv2.android.model

import android.content.Context
import android.webkit.URLUtil
import bou.amine.apps.readerforselfossv2.android.utils.acra.sendSilentlyWithAcraWithName
import bou.amine.apps.readerforselfossv2.android.utils.glide.preloadImage
import bou.amine.apps.readerforselfossv2.model.SelfossModel
import bou.amine.apps.readerforselfossv2.service.AppSettingsService
import bou.amine.apps.readerforselfossv2.utils.getImages

fun SelfossModel.Item.preloadImages(
    context: Context,
    appSettingsService: AppSettingsService,
): Boolean {
    val imageUrls = this.getImages()

    try {
        for (url in imageUrls) {
            if (URLUtil.isValidUrl(url)) {
                context.preloadImage(url, appSettingsService)
            }
        }
    } catch (e: Error) {
        e.sendSilentlyWithAcraWithName("preloadImages")
        return false
    }

    return true
}

fun String.toTextDrawableString(): String {
    val textDrawable = StringBuilder()
    for (s in this.split(" ".toRegex()).filter { it.isNotEmpty() }.toTypedArray()) {
        try {
            textDrawable.append(s[0])
        } catch (e: StringIndexOutOfBoundsException) {
            e.sendSilentlyWithAcraWithName("toTextDrawableString")
        }
    }
    return textDrawable.toString()
}
