package bou.amine.apps.readerforselfossv2.android

import android.content.Context
import androidx.test.espresso.Espresso.onView
import androidx.test.espresso.IdlingRegistry
import androidx.test.espresso.action.ViewActions
import androidx.test.espresso.action.ViewActions.click
import androidx.test.espresso.assertion.ViewAssertions.matches
import androidx.test.espresso.matcher.ViewMatchers.isChecked
import androidx.test.espresso.matcher.ViewMatchers.isDisplayed
import androidx.test.espresso.matcher.ViewMatchers.isEnabled
import androidx.test.espresso.matcher.ViewMatchers.isNotEnabled
import androidx.test.espresso.matcher.ViewMatchers.isRoot
import androidx.test.espresso.matcher.ViewMatchers.withText
import androidx.test.ext.junit.rules.ActivityScenarioRule
import androidx.test.ext.junit.runners.AndroidJUnit4
import androidx.test.filters.LargeTest
import bou.amine.apps.readerforselfossv2.android.settings.SettingsActivity
import bou.amine.apps.readerforselfossv2.android.testing.CountingIdlingResourceSingleton
import org.hamcrest.CoreMatchers.allOf
import org.hamcrest.CoreMatchers.not
import org.junit.After
import org.junit.Before
import org.junit.Rule
import org.junit.Test
import org.junit.runner.RunWith

@Suppress("ktlint:standard:class-naming", "detekt:ClassNaming")
@RunWith(AndroidJUnit4::class)
@LargeTest
class `6-SettingsActivityOfflineTest` : WithANRException() {
    @get:Rule
    val activityRule = ActivityScenarioRule(SettingsActivity::class.java)

    lateinit var context: Context

    @Before
    fun init() {
        activityRule.scenario.onActivity { activity ->
            context = activity.window.context
        }
        IdlingRegistry
            .getInstance()
            .register(CountingIdlingResourceSingleton.countingIdlingResource)
        onView(withText(R.string.pref_header_offline)).perform(click())
    }

    @After
    fun back() {
        onView(isRoot()).perform(ViewActions.pressBack())
    }

    @Suppress("detekt:LongMethod")
    @Test
    fun testOffline() {
        onView(withSettingsCheckboxWidget(R.string.pref_switch_periodic_refresh)).check(
            matches(
                allOf(
                    isDisplayed(),
                    not(isChecked()),
                ),
            ),
        )
        onView(withSettingsCheckboxWidget(R.string.pref_switch_items_caching)).check(
            matches(
                allOf(
                    isDisplayed(),
                    not(isChecked()),
                ),
            ),
        )
        onView(withSettingsCheckboxFrame(R.string.pref_switch_items_caching)).check(
            matches(
                isEnabled(),
            ),
        )
        onView(withText(R.string.pref_periodic_refresh_minutes_title)).check(
            matches(
                allOf(isNotEnabled(), isDisplayed()),
            ),
        )

        onView(withSettingsCheckboxWidget(R.string.pref_switch_refresh_when_charging)).check(
            matches(
                allOf(
                    isDisplayed(),
                    not(isChecked()),
                ),
            ),
        )
        onView(withSettingsCheckboxFrame(R.string.pref_switch_refresh_when_charging)).check(
            matches(
                isNotEnabled(),
            ),
        )
        onView(withSettingsCheckboxWidget(R.string.pref_switch_notify_new_items)).check(
            matches(
                allOf(
                    isDisplayed(),
                    not(isChecked()),
                ),
            ),
        )
        onView(withSettingsCheckboxFrame(R.string.pref_switch_notify_new_items)).check(
            matches(
                isNotEnabled(),
            ),
        )
        onView(withSettingsCheckboxWidget(R.string.pref_switch_update_sources)).check(
            matches(
                allOf(
                    isDisplayed(),
                    isChecked(),
                ),
            ),
        )
    }

    @Suppress("detekt:LongMethod")
    @Test
    fun testOfflineActions() {
        onView(withText(R.string.pref_switch_items_caching_off)).check(matches(isDisplayed()))
        onView(withText(R.string.pref_switch_items_caching)).perform(click())
        onView(withText(R.string.pref_switch_items_caching_on)).check(matches(isDisplayed()))
        onView(withSettingsCheckboxFrame(R.string.pref_switch_items_caching)).check(
            matches(
                isEnabled(),
            ),
        )
        onView(withText(R.string.pref_periodic_refresh_minutes_title)).check(
            matches(
                isNotEnabled(),
            ),
        )
        onView(withSettingsCheckboxFrame(R.string.pref_switch_refresh_when_charging)).check(
            matches(
                isNotEnabled(),
            ),
        )
        onView(withSettingsCheckboxFrame(R.string.pref_switch_notify_new_items)).check(
            matches(
                isNotEnabled(),
            ),
        )

        onView(withText(R.string.pref_switch_periodic_refresh_off)).check(
            matches(
                isDisplayed(),
            ),
        )
        onView(withSettingsCheckboxWidget(R.string.pref_switch_periodic_refresh)).perform(click())
        onView(withText(R.string.pref_switch_periodic_refresh_on)).check(
            matches(
                isDisplayed(),
            ),
        )
        onView(withSettingsCheckboxFrame(R.string.pref_periodic_refresh_minutes_title)).check(
            matches(
                isEnabled(),
            ),
        )
        onView(withSettingsCheckboxFrame(R.string.pref_switch_refresh_when_charging)).check(
            matches(
                isEnabled(),
            ),
        )
        onView(withSettingsCheckboxFrame(R.string.pref_switch_notify_new_items)).check(
            matches(
                isEnabled(),
            ),
        )
        changeAndCancelSetting("360", "123") {
            onView(withText(R.string.pref_periodic_refresh_minutes_title)).perform(click())
        }
        changeAndSaveSetting("360", "123") {
            onView(withText(R.string.pref_periodic_refresh_minutes_title)).perform(click())
        }
        onView(withSettingsCheckboxFrame(R.string.pref_switch_refresh_when_charging)).perform(click())
        onView(withSettingsCheckboxFrame(R.string.pref_switch_notify_new_items)).perform(click())
        onView(withSettingsCheckboxWidget(R.string.pref_switch_update_sources)).perform(click())
    }
}
