package bou.amine.apps.readerforselfossv2.android

import android.content.Context
import androidx.test.espresso.Espresso.onView
import androidx.test.espresso.IdlingRegistry
import androidx.test.espresso.action.ViewActions
import androidx.test.espresso.action.ViewActions.click
import androidx.test.espresso.assertion.ViewAssertions.matches
import androidx.test.espresso.matcher.ViewMatchers.isChecked
import androidx.test.espresso.matcher.ViewMatchers.isDisplayed
import androidx.test.espresso.matcher.ViewMatchers.isRoot
import androidx.test.espresso.matcher.ViewMatchers.withText
import androidx.test.ext.junit.rules.ActivityScenarioRule
import androidx.test.ext.junit.runners.AndroidJUnit4
import androidx.test.filters.LargeTest
import bou.amine.apps.readerforselfossv2.android.settings.SettingsActivity
import bou.amine.apps.readerforselfossv2.android.testing.CountingIdlingResourceSingleton
import org.hamcrest.CoreMatchers.allOf
import org.hamcrest.CoreMatchers.not
import org.junit.After
import org.junit.Before
import org.junit.Rule
import org.junit.Test
import org.junit.runner.RunWith

@Suppress("ktlint:standard:class-naming", "detekt:ClassNaming")
@RunWith(AndroidJUnit4::class)
@LargeTest
class `5-SettingsActivityReaderTest` : WithANRException() {
    @get:Rule
    val activityRule = ActivityScenarioRule(SettingsActivity::class.java)

    lateinit var context: Context

    @Before
    fun init() {
        activityRule.scenario.onActivity { activity ->
            context = activity.window.context
        }
        IdlingRegistry
            .getInstance()
            .register(CountingIdlingResourceSingleton.countingIdlingResource)
        onView(withText(R.string.pref_header_viewer)).perform(click())
    }

    @After
    fun back() {
        onView(isRoot()).perform(ViewActions.pressBack())
    }

    @Test
    fun testReader() {
        onView(withSettingsCheckboxFrame(R.string.pref_switch_actions_pager_scroll)).check(
            matches(
                allOf(
                    isDisplayed(),
                    not(
                        isChecked(),
                    ),
                ),
            ),
        )
        onView(withText(R.string.pref_content_reader_font_size)).check(matches(isDisplayed()))
        onView(withText(R.string.settings_reader_font)).check(matches(isDisplayed()))
    }

    @Test
    fun testReaderActions() {
        onView(withText(R.string.pref_switch_actions_pager_scroll_off)).check(
            matches(
                isDisplayed(),
            ),
        )
        onView(withSettingsCheckboxFrame(R.string.pref_switch_actions_pager_scroll)).perform(click())
        onView(withText(R.string.pref_switch_actions_pager_scroll_on)).check(
            matches(
                isDisplayed(),
            ),
        )

        onView(withText(R.string.pref_content_reader_font_size)).perform(click())
        changeAndCancelSetting("16", "10") {
            onView(withText(R.string.pref_content_reader_font_size)).perform(click())
        }
        changeAndSaveSetting("16", "10") {
            onView(withText(R.string.pref_content_reader_font_size)).perform(click())
        }

        testPreferencesFromArray(context, R.array.preloaded_fonts_values) {
            onView(withText(R.string.settings_reader_font)).perform(click())
        }
    }
}
