package bou.amine.apps.readerforselfossv2.android

import androidx.test.espresso.Espresso.onView
import androidx.test.espresso.IdlingRegistry
import androidx.test.espresso.action.ViewActions
import androidx.test.espresso.action.ViewActions.click
import androidx.test.espresso.assertion.ViewAssertions.matches
import androidx.test.espresso.matcher.ViewMatchers.isClickable
import androidx.test.espresso.matcher.ViewMatchers.isDisplayed
import androidx.test.espresso.matcher.ViewMatchers.isFocused
import androidx.test.espresso.matcher.ViewMatchers.isRoot
import androidx.test.espresso.matcher.ViewMatchers.isSelected
import androidx.test.espresso.matcher.ViewMatchers.withId
import androidx.test.espresso.matcher.ViewMatchers.withText
import androidx.test.ext.junit.rules.ActivityScenarioRule
import androidx.test.ext.junit.runners.AndroidJUnit4
import androidx.test.filters.LargeTest
import bou.amine.apps.readerforselfossv2.android.testing.CountingIdlingResourceSingleton
import org.hamcrest.CoreMatchers.not
import org.junit.Before
import org.junit.FixMethodOrder
import org.junit.Rule
import org.junit.Test
import org.junit.runner.RunWith
import org.junit.runners.MethodSorters

@Suppress("ktlint:standard:class-naming", "detekt:ClassNaming")
@RunWith(AndroidJUnit4::class)
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
@LargeTest
class `2-HomeActivityTest` : WithANRException() {
    @get:Rule
    val activityRule = ActivityScenarioRule(HomeActivity::class.java)

    @Before
    fun registerIdlingResource() {
        IdlingRegistry
            .getInstance()
            .register(CountingIdlingResourceSingleton.countingIdlingResource)
        checkHomeLoadingDone()
    }

    @Test
    fun testMenu() {
        onView(withId(R.id.action_search)).check(matches(isDisplayed())).check(
            matches(
                isClickable(),
            ),
        )
        onView(withId(R.id.action_filter)).check(matches(isDisplayed())).check(
            matches(
                isClickable(),
            ),
        )
        openMenu()
        onView(withText(R.string.readAll)).check(matches(isDisplayed()))
        onView(withText(R.string.menu_home_sources)).check(matches(isDisplayed()))
        onView(withText(R.string.title_activity_settings)).check(matches(isDisplayed()))
        onView(withText(R.string.menu_home_refresh)).check(matches(isDisplayed()))
        onView(withText(R.string.issue_tracker_link)).check(matches(isDisplayed()))
        onView(withText(R.string.action_disconnect)).check(matches(isDisplayed()))
    }

    @Test
    fun testMenuActions() {
        onView(withId(R.id.action_search)).perform(click())
        onView(
            withId(com.google.android.material.R.id.search_src_text),
        ).check(matches(isFocused()))
        onView(isRoot()).perform(ViewActions.pressBack())

        onView(withId(R.id.action_filter)).perform(click())
        onView(
            withText(R.string.filter_item_sources),
        ).check(matches(isDisplayed()))
        onView(
            withText(R.string.filter_item_tags),
        ).check(matches(isDisplayed()))
        onView(
            withId(R.id.floatingActionButton2),
        ).check(matches(isDisplayed()))
        onView(isRoot()).perform(ViewActions.pressBack())

        openMenu()
        onView(withText(R.string.readAll)).perform(click())
        onView(withText(R.string.markall_dialog_message)).check(matches(isDisplayed()))
        onView(isRoot()).perform(ViewActions.pressBack())
        openMenu()

        onView(withText(R.string.menu_home_sources)).perform(click())
        onView(withId(R.id.fab)).check(matches(isDisplayed()))
        onView(isRoot()).perform(ViewActions.pressBack())
        openMenu()

        onView(withText(R.string.title_activity_settings)).perform(click())
        onView(withText(R.string.pref_header_general)).check(matches(isDisplayed()))
        onView(isRoot()).perform(ViewActions.pressBack())
        openMenu()

        onView(withText(R.string.menu_home_refresh)).perform(click())
        onView(withText(R.string.refresh_dialog_message)).check(matches(isDisplayed()))
        onView(isRoot()).perform(ViewActions.pressBack())
        openMenu()

        /*onView(withText(R.string.issue_tracker_link)).perform(click())
        onView(withText(R.string.markall_dialog_message)).check(matches(isDisplayed()))
        onView(isRoot()).perform(ViewActions.pressBack())
        openMenu()*/

        onView(withText(R.string.action_disconnect)).perform(click())
        onView(withText(R.string.confirm_disconnect_title)).check(matches(isDisplayed()))
    }

    @Test
    fun testEmptyView() {
        onView(withId(R.id.emptyText)).check(matches(isDisplayed()))
        onView(
            hasBottombarItemText(R.string.tab_new),
        ).check(matches(isDisplayed())).check(matches(isSelected()))
        onView(
            hasBottombarItemText(R.string.tab_read),
        ).check(matches(isDisplayed())).check(matches(not(isSelected())))
        onView(
            hasBottombarItemText(R.string.tab_favs),
        ).check(matches(isDisplayed())).check(matches(not(isSelected())))
    }
}
