package bou.amine.apps.readerforselfossv2.service

import dev.jordond.connectivity.Connectivity
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.flow.MutableSharedFlow
import kotlinx.coroutines.flow.asSharedFlow
import kotlinx.coroutines.launch

class ConnectivityService {
    private val _networkAvailableProvider = MutableSharedFlow<Boolean>()
    val networkAvailableProvider = _networkAvailableProvider.asSharedFlow()
    private var currentStatus = true
    private lateinit var connectivity: Connectivity

    fun start() {
        connectivity = Connectivity()
        connectivity.start()
        CoroutineScope(Dispatchers.Default).launch {
            connectivity.statusUpdates.collect { status ->
                when (status) {
                    is Connectivity.Status.Connected -> {
                        if (!currentStatus) {
                            currentStatus = true
                            _networkAvailableProvider.emit(true)
                        }
                    }

                    is Connectivity.Status.Disconnected -> {
                        if (currentStatus) {
                            currentStatus = false
                            _networkAvailableProvider.emit(false)
                        }
                    }
                }
            }
        }
    }

    fun isNetworkAvailable(): Boolean = currentStatus

    fun stop() {
        currentStatus = true
        connectivity.stop()
    }
}
