package bou.amine.apps.readerforselfossv2.model

import kotlinx.serialization.Serializable

@Serializable
class SuccessResponse(
    val success: Boolean,
) {
    val isSuccess: Boolean
        get() = success
}

class StatusAndData<T>(
    val success: Boolean,
    val data: T? = null,
) {
    companion object {
        fun <T> succes(d: T): StatusAndData<T> = StatusAndData(true, d)

        fun <T> error(): StatusAndData<T> = StatusAndData(false)
    }
}
