package bou.amine.apps.readerforselfossv2.utils

import android.net.Uri
import android.text.Html
import bou.amine.apps.readerforselfossv2.model.SelfossModel
import org.jsoup.Jsoup
import java.util.Locale

actual fun String.getHtmlDecoded(): String = Html.fromHtml(this).toString()

actual fun SelfossModel.Item.getIcon(baseUrl: String): String = constructUrl(baseUrl, "favicons", icon)

actual fun SelfossModel.Item.getThumbnail(baseUrl: String): String = constructUrl(baseUrl, "thumbnails", thumbnail)

val IMAGE_EXTENSION_REGEXP = """\.(jpg|jpeg|png|webp)""".toRegex()

actual fun SelfossModel.Item.getImages(): ArrayList<String> {
    val allImages = ArrayList<String>()

    for (image in Jsoup.parse(content).getElementsByTag("img")) {
        val url = image.attr("src")
        if (IMAGE_EXTENSION_REGEXP.containsMatchIn(url.lowercase(Locale.US))) {
            allImages.add(url)
        }
    }
    return allImages
}

actual fun SelfossModel.Source.getIcon(baseUrl: String): String = constructUrl(baseUrl, "favicons", icon)

actual fun constructUrl(
    baseUrl: String,
    path: String,
    file: String?,
): String =
    if (file == null || file == "null" || file.isEmpty()) {
        ""
    } else {
        val baseUriBuilder = Uri.parse(baseUrl).buildUpon()
        baseUriBuilder.appendPath(path).appendPath(file)

        baseUriBuilder.toString()
    }
