val ktorVersion = "3.0.3"

object SqlDelight {
    const val runtime = "app.cash.sqldelight:runtime:2.0.2"
    const val android = "app.cash.sqldelight:android-driver:2.0.2"
    const val native = "app.cash.sqldelight:native-driver:2.0.2"
}

plugins {
    kotlin("multiplatform")
    id("com.android.library")
    kotlin("plugin.serialization") version "1.9.0"
    id("org.jetbrains.kotlinx.kover")
    id("app.cash.sqldelight") version "2.0.2"
}

kotlin {
    androidTarget()

    listOf(
        iosX64(),
        iosArm64(),
        // iosSimulatorArm64()
    ).forEach {
        it.binaries.framework {
            baseName = "shared"
        }
    }

    sourceSets {
        val commonMain by getting {
            dependencies {
                implementation("io.ktor:ktor-client-core:$ktorVersion")
                implementation("io.ktor:ktor-client-content-negotiation:$ktorVersion")
                implementation("io.ktor:ktor-serialization-kotlinx-json:$ktorVersion")
                implementation("io.ktor:ktor-client-logging:$ktorVersion")
                implementation("io.ktor:ktor-client-auth:$ktorVersion")
                implementation("io.ktor:ktor-client-cio:$ktorVersion")
                implementation("org.jetbrains.kotlinx:kotlinx-coroutines-core:1.10.1")

                implementation("org.jsoup:jsoup:1.15.4")

                // Dependency Injection
                implementation("org.kodein.di:kodein-di:7.14.0")

                // Settings
                implementation("com.russhwolf:multiplatform-settings-no-arg:1.0.0-RC")

                // Logging
                implementation("io.github.aakira:napier:2.6.1")

                // Sql
                implementation(SqlDelight.runtime)

                // Sql
                implementation("org.jetbrains.kotlinx:kotlinx-datetime:0.6.1")

                // Connectivity
                implementation("dev.jordond.connectivity:connectivity-core:1.2.0")
                implementation("dev.jordond.connectivity:connectivity-device:1.2.0")
            }
        }
        val commonTest by getting {
            dependencies {
                implementation(kotlin("test-common"))
                implementation(kotlin("test-annotations-common"))
            }
        }
        val androidMain by getting {
            dependencies {
                implementation("com.squareup.okhttp3:okhttp:4.11.0")
                implementation("org.jetbrains.kotlinx:kotlinx-datetime:0.4.0")

                // Sql
                implementation(SqlDelight.android)
            }
        }
        val androidUnitTest by getting {
            dependencies {
                implementation(kotlin("test-junit"))
                implementation("junit:junit:4.13.2")
            }
        }
        val iosX64Main by getting
        val iosArm64Main by getting
        // val iosSimulatorArm64Main by getting
        val iosMain by creating {

            dependencies {
                implementation(SqlDelight.native)
            }
        }
        val iosX64Test by getting
        val iosArm64Test by getting
        // val iosSimulatorArm64Test by getting
        val iosTest by creating {
        }
    }
}

android {
    compileSdk = 34
    sourceSets["main"].manifest.srcFile("src/androidMain/AndroidManifest.xml")
    defaultConfig {
        minSdk = 25
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_17
        targetCompatibility = JavaVersion.VERSION_17
    }
    namespace = "bou.amine.apps.readerforselfossv2"
}

sqldelight {
    databases {
        create("ReaderForSelfossDB") {
            packageName.set("bou.amine.apps.readerforselfossv2.dao")
        }
    }
}
