package bou.amine.apps.readerforselfossv2.android.testing

import androidx.test.espresso.idling.CountingIdlingResource

object CountingIdlingResourceSingleton {
    private const val RESOURCE = "GLOBAL"

    @JvmField
    val countingIdlingResource = CountingIdlingResource(RESOURCE)

    fun increment() {
        countingIdlingResource.increment()
    }

    fun decrement() {
        if (!countingIdlingResource.isIdleNow) {
            countingIdlingResource.decrement()
        }
    }
}
