package bou.amine.apps.readerforselfossv2.android

import android.content.Context
import androidx.test.espresso.Espresso.onView
import androidx.test.espresso.IdlingRegistry
import androidx.test.espresso.action.ViewActions.click
import androidx.test.espresso.assertion.ViewAssertions.matches
import androidx.test.espresso.matcher.ViewMatchers.isDisplayed
import androidx.test.espresso.matcher.ViewMatchers.isRoot
import androidx.test.espresso.matcher.ViewMatchers.isSelected
import androidx.test.espresso.matcher.ViewMatchers.withText
import androidx.test.ext.junit.rules.ActivityScenarioRule
import androidx.test.ext.junit.runners.AndroidJUnit4
import androidx.test.filters.LargeTest
import bou.amine.apps.readerforselfossv2.android.testing.CountingIdlingResourceSingleton
import org.hamcrest.CoreMatchers.allOf
import org.hamcrest.CoreMatchers.not
import org.junit.Before
import org.junit.Rule
import org.junit.Test
import org.junit.runner.RunWith

@RunWith(AndroidJUnit4::class)
@LargeTest
@Suppress("ktlint:standard:class-naming", "detekt:ClassNaming")
class `3-SettingsActivityTest` : WithANRException() {
    @get:Rule
    val activityRule = ActivityScenarioRule(HomeActivity::class.java)

    lateinit var context: Context

    @Before
    fun init() {
        activityRule.scenario.onActivity { activity ->
            context = activity.window.context
        }
        IdlingRegistry
            .getInstance()
            .register(CountingIdlingResourceSingleton.countingIdlingResource)
        openMenu()
        onView(withText(R.string.title_activity_settings)).perform(click())
    }

    @Test
    fun testAllSettings() {
        onView(withText(R.string.pref_header_general)).check(matches(isDisplayed()))
        onView(withText(R.string.pref_header_viewer)).check(matches(isDisplayed()))
        onView(withText(R.string.pref_header_offline)).check(matches(isDisplayed()))
        onView(withText(R.string.pref_header_theme)).check(matches(isDisplayed()))
        onView(withText(R.string.pref_header_links)).check(matches(isDisplayed()))
        onView(withText(R.string.pref_switch_disable_acra)).check(
            matches(
                allOf(
                    isDisplayed(),
                    not(isSelected()),
                ),
            ),
        )
        onView(withText(R.string.action_about)).check(matches(isDisplayed()))
    }

    @Test
    fun testThemes() {
        testPreferencesFromArray(context, R.array.ModeTitles) {
            onView(withText(R.string.pref_header_theme)).perform(click())
        }
    }

    @Test
    fun testExperimentail() {
        onView(withText(R.string.pref_header_experimental)).perform(click())
        changeAndCancelSetting("", "10") {
            onView(withText(R.string.pref_api_timeout)).perform(click())
        }
        changeAndSaveSetting("", "10") {
            onView(withText(R.string.pref_api_timeout)).perform(click())
        }
        changeAndSaveSetting("", "60") {
            onView(withText(R.string.pref_api_timeout)).perform(click())
        }
    }

    @Test
    fun testBugReports() {
        onView(withText(R.string.pref_switch_disable_acra)).perform(click())
    }

    @Test
    fun testLinks() {
        onView(withText(R.string.pref_header_links)).perform(click())
        onView(withText(R.string.issue_tracker_link)).check(matches(isDisplayed()))
        onView(withText(R.string.issue_tracker_summary)).check(matches(isDisplayed()))
        onView(withText(R.string.source_code)).check(matches(isDisplayed()))
        onView(withText(R.string.translation)).check(matches(isDisplayed()))
    }

    @Test
    fun testAbout() {
        onView(withText(R.string.action_about)).perform(click())
        onView(isRoot()).perform(waitUntilShown("ACRA", 30000))
        onView(withText("ACRA")).check(matches(isDisplayed()))
    }
}
