package bou.amine.apps.readerforselfossv2.android

import androidx.test.espresso.Espresso.onView
import androidx.test.espresso.IdlingRegistry
import androidx.test.espresso.action.ViewActions.click
import androidx.test.espresso.assertion.ViewAssertions.matches
import androidx.test.espresso.matcher.ViewMatchers.isClickable
import androidx.test.espresso.matcher.ViewMatchers.isDisplayed
import androidx.test.espresso.matcher.ViewMatchers.isNotChecked
import androidx.test.espresso.matcher.ViewMatchers.withId
import androidx.test.espresso.matcher.ViewMatchers.withText
import androidx.test.ext.junit.rules.ActivityScenarioRule
import androidx.test.ext.junit.runners.AndroidJUnit4
import androidx.test.filters.LargeTest
import bou.amine.apps.readerforselfossv2.android.testing.CountingIdlingResourceSingleton
import org.junit.After
import org.junit.Before
import org.junit.FixMethodOrder
import org.junit.Rule
import org.junit.Test
import org.junit.runner.RunWith
import org.junit.runners.MethodSorters

@Suppress("ktlint:standard:class-naming", "detekt:ClassNaming")
@RunWith(AndroidJUnit4::class)
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
@LargeTest
class `1-LoginActivityTest` : WithANRException() {
    @get:Rule
    val activityRule = ActivityScenarioRule(LoginActivity::class.java)

    @Before
    fun registerIdlingResource() {
        IdlingRegistry
            .getInstance()
            .register(CountingIdlingResourceSingleton.countingIdlingResource)
    }

    @After
    fun unregisterIdlingResource() {
        IdlingRegistry
            .getInstance()
            .unregister(CountingIdlingResourceSingleton.countingIdlingResource)
    }

    @Test
    fun `1-viewIsInitialized`() {
        onView(withId(R.id.urlView)).check(matches(isDisplayed()))
        onView(withId(R.id.selfSigned))
            .check(matches(isDisplayed()))
            .check(matches(isNotChecked()))
            .check(
                matches(isClickable()),
            )
        onView(withId(R.id.withLogin))
            .check(matches(isDisplayed()))
            .check(matches(isNotChecked()))
            .check(
                matches(isClickable()),
            )
    }

    @Test
    fun `2-urlError`() {
        performLogin("10.0.2.2:8888")
        onView(withId(R.id.urlView)).perform(click())
        onView(withId(R.id.urlView)).check(matches(withError(R.string.login_url_problem)))
    }

    @Test
    fun `3-urlSlashError`() {
        performLogin("https://google.fr/toto")
        onView(withId(R.id.urlView)).perform(click())
        onView(withId(R.id.urlView)).check(matches(withError(R.string.login_url_problem)))
    }

    @Test
    fun `4-connectError`() {
        performLogin("http://10.0.2.2:8889")
        onView(withId(R.id.urlView)).check(matches(withError(R.string.wrong_infos)))
    }

    @Test
    fun `5-multiError`() {
        onView(withId(R.id.signInButton)).perform(click())
        onView(withId(R.id.signInButton)).perform(click())
        onView(withId(R.id.signInButton)).perform(click())
        onView(withText(R.string.warning_wrong_url)).check(matches(isDisplayed()))
    }

    @Test
    fun `6-connect`() {
        performLogin()
        onView(withText(R.string.gdpr_dialog_title)).check(matches(isDisplayed()))
        onView(withText("OK")).perform(click())
        checkHomeLoadingDone()
    }
}
