package apps.droidnotify.services;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;

import apps.droidnotify.common.Common;
import apps.droidnotify.common.Constants;
import apps.droidnotify.log.Log;
import apps.droidnotify.receivers.K9AlarmReceiver;

public class K9BroadcastReceiverService extends WakefulIntentService {

	//================================================================================
	// Public Methods
	//================================================================================
	
	/**
	 * Class Constructor.
	 */
	public K9BroadcastReceiverService() {
		super("K9BroadcastReceiverService");
	}

	//================================================================================
	// Protected Methods
	//================================================================================
	
	/**
	 * Do the work for the service inside this function.
	 * 
	 * @param intent - Intent object that we are working with.
	 */
	@Override
	protected void doWakefulWork(Intent intent) {
		Context context = getApplicationContext();
		try{
			SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences(context);
			//Block the notification if it's quiet time.
			if(Common.isQuietTime(context)){
				Log.e(context, "K9BroadcastReceiverService.doWakefulWork() Quiet Time. Exiting...");
				return;
			}
			//Schedule task x seconds after the broadcast.
			//This time is set by the users advanced preferences. 1 seconds is the default value.
			//This should allow enough time to pass for the email db to be written to.
			long timeoutInterval = Long.parseLong(preferences.getString(Constants.K9_TIMEOUT_KEY, "1")) * 1000;
			String intentActionText = intent.getAction() + "/" + String.valueOf(System.currentTimeMillis());
			long alarmTime = System.currentTimeMillis() + timeoutInterval;
			Common.startAlarm(context, K9AlarmReceiver.class, intent.getExtras(), intentActionText, alarmTime);
		}catch(Exception ex){
			Log.e(context, "K9BroadcastReceiverService.doWakefulWork() ERROR: " + ex.toString());
		}
	}
		
}