package app.shosetsu.android.domain.model.local.backup

import app.shosetsu.android.common.enums.ChapterSortType
import app.shosetsu.android.common.enums.ReadingStatus
import kotlinx.serialization.Serializable

/*
 * This file is part of shosetsu.
 *
 * shosetsu is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * shosetsu is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with shosetsu.  If not, see <https://www.gnu.org/licenses/>.
 */

/**
 * Shosetsu
 *
 * @since 05 / 07 / 2021
 * @author Doomsdayrs
 */
@Serializable
data class BackupNovelSettingEntity(
	val sortType: ChapterSortType = ChapterSortType.SOURCE,
	val showOnlyReadingStatusOf: ReadingStatus? = null,
	val showOnlyBookmarked: Boolean = false,
	val showOnlyDownloaded: Boolean = false,
	val reverseOrder: Boolean = false,
)