import 'package:flutter/services.dart';

enum CalibrationStatus {
  UNKNOWN,
  UNRELIABLE,
  ACCURACY_LOW,
  ACCURACY_MEDIUM,
  ACCURACY_HIGH
}

class MagnetometerCalibrationService {
  static const _eventChannel = EventChannel('app.panoramax.beta/magnetometer_calibration');

  static Stream<CalibrationStatus> get calibrationStatusStream => _eventChannel
        .receiveBroadcastStream()
        .map((dynamic event) {
          switch (event as String) {
            case 'unreliable':
              return CalibrationStatus.UNRELIABLE;
            case 'accuracy_low':
              return CalibrationStatus.ACCURACY_LOW;
            case 'accuracy_medium':
              return CalibrationStatus.ACCURACY_MEDIUM;
            case 'accuracy_high':
              return CalibrationStatus.ACCURACY_HIGH;
            default:
              return CalibrationStatus.UNKNOWN;
          }
        });
}
