import 'package:drift/drift.dart';

class Sequences extends Table {
  IntColumn get id => integer().autoIncrement()();
  TextColumn get panoramaxSequenceId => text().nullable()();
  TextColumn get name => text()();
  DateTimeColumn get creationDate => dateTime()();
}

// Définition de la table pour les images de séquence
class SequencePictures extends Table {
  IntColumn get id => integer().autoIncrement()();
  TextColumn get localFilePath => text()();
  BoolColumn get isToSend => boolean().withDefault(const Constant(true))();
  BoolColumn get hasBeenSent => boolean().withDefault(const Constant(false))();
  BoolColumn get doesImageHaveCorrectExifTags => boolean().withDefault(const Constant(true))();
  IntColumn get sequenceId => integer().references(Sequences, #id)();
}