import 'package:drift/drift.dart' as drift;

import 'database.dart';

class SequenceDto {
  int id = 0;
  String? panoramaxSequenceId;
  late String name;
  late DateTime creationDate;
  List<SequencePictureDto> pictures = [];

  SequenceDto();

  SequenceDto.fromDrift(Sequence driftSequence, List<SequencePicture> driftPictures) {
    id = driftSequence.id;
    panoramaxSequenceId = driftSequence.panoramaxSequenceId;
    name = driftSequence.name;
    creationDate = driftSequence.creationDate;
    pictures = driftPictures.map((p) => SequencePictureDto.fromDrift(p, this)).toList();
  }

  SequencesCompanion toDrift() => SequencesCompanion(
      id: id == 0 ? const drift.Value.absent() : drift.Value(id),
      panoramaxSequenceId: drift.Value(panoramaxSequenceId),
      name: drift.Value(name),
      creationDate: drift.Value(creationDate),
    );

  @override
  String toString() => 'SequenceDto{id: $id, panoramaxSequenceId: $panoramaxSequenceId, name: $name, creationDate: $creationDate, pictures: $pictures}';
}

class SequencePictureDto {
  int id = 0;
  late String localFilePath;
  bool isToSend = true;
  bool hasBeenSent = false;
  bool doesImageHaveCorrectExifTags = true;
  SequenceDto? _sequence;

  SequencePictureDto();

  SequenceDto get sequence => _sequence!;
  set sequence(SequenceDto value) => _sequence = value;

  SequencePictureDto.fromDrift(SequencePicture driftPicture, SequenceDto sequence) {
    id = driftPicture.id;
    localFilePath = driftPicture.localFilePath;
    isToSend = driftPicture.isToSend;
    hasBeenSent = driftPicture.hasBeenSent;
    doesImageHaveCorrectExifTags = driftPicture.doesImageHaveCorrectExifTags;
    _sequence = sequence;
  }

  SequencePicturesCompanion toDrift() => SequencePicturesCompanion(
      id: id == 0 ? const drift.Value.absent() : drift.Value(id),
      localFilePath: drift.Value(localFilePath),
      isToSend: drift.Value(isToSend),
      hasBeenSent: drift.Value(hasBeenSent),
      doesImageHaveCorrectExifTags: drift.Value(doesImageHaveCorrectExifTags),
      sequenceId: drift.Value(_sequence?.id ?? 0),
    );

  @override
  String toString() => 'SequencePictureDto{id: $id, localFilePath: $localFilePath, isToSend: $isToSend, hasBeenSent: $hasBeenSent, doesImageHaveCorrectExifTags: $doesImageHaveCorrectExifTags}';
}