import 'dart:io';

import 'package:drift/drift.dart';
import 'package:drift/native.dart';
import 'package:path/path.dart' as p;
import 'package:path_provider/path_provider.dart';

import 'schema.dart';

part 'database.g.dart';

// Définition de la base de données
@DriftDatabase(tables: [Sequences, SequencePictures])
class PanoramaxDatabase extends _$PanoramaxDatabase {
  PanoramaxDatabase() : super(_openConnection());

  @override
  int get schemaVersion => 1;
}

// Ouvre une connexion à la base de données
LazyDatabase _openConnection() => LazyDatabase(() async {
  final dbFolder = await getApplicationDocumentsDirectory();
  final file = File(p.join(dbFolder.path, 'panoramax-mobile.sqlite'));
  return NativeDatabase(file);
});