part of panoramax;

class SettingsProvider with ChangeNotifier {
  bool currentIsFlashTurnOn = false;
  bool currentReduceBrightnessOnCapture = true;
  bool currentSentViaWifiOnly = true;

  bool get isFlashTurnOn => currentIsFlashTurnOn;
  bool get reduceBrightnessOnCapture => currentReduceBrightnessOnCapture;
  bool get sentViaWifiOnly => currentSentViaWifiOnly;

  void changeIsFlash(bool flashTurnOn) {
    currentIsFlashTurnOn = flashTurnOn;
    notifyListeners();
  }

  void changeReduceBrightnessOnCapture(bool reduceBrightnessOnCapture) {
    currentReduceBrightnessOnCapture = reduceBrightnessOnCapture;
    notifyListeners();
  }

  void changeSentViaWifiOnly(bool sentViaWifiOnly) {
    currentSentViaWifiOnly = sentViaWifiOnly;
    notifyListeners();
  }
}
