// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Chinese (`zh`).
class AppLocalizationsZh extends AppLocalizations {
  AppLocalizationsZh([String locale = 'zh']) : super(locale);

  @override
  String get common_close => '關閉';

  @override
  String get common_success => '成功';

  @override
  String get common_error => '錯誤';

  @override
  String get common_ok => '確認';

  @override
  String get common_permissionDenied => '權限被拒絕';

  @override
  String get common_dateFormat => 'yy/MM/dd - HH:mm';

  @override
  String get button_submit => '提交';

  @override
  String get yourSequence => '你的序列';

  @override
  String get createSequence_tooltip => '新增序列';

  @override
  String get unknownError => 'Oops ! An error occurred…';

  @override
  String get retry => 'Retry';

  @override
  String get remoteCollectionRetrieveError => 'Error when loading remote photos';

  @override
  String get loading => 'Loading…';

  @override
  String get emptyTitle => 'Help us map the world!';

  @override
  String get emptySubTitle1 => '🌍 Build unique routes.';

  @override
  String get emptyBody1 => 'You haven\'t captured photo yet?\nContribute today to create immersive views of the streets and landscapes around you.';

  @override
  String get emptySubTitle2 => '📸 Take your first photo now!';

  @override
  String get emptyBody2 => 'Explore your surroundings, take a photo and take part in mapping the world.';

  @override
  String get mySequences => 'My pictures';

  @override
  String elements(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count elements',
      one: '1 element',
      zero: 'no element',
    );
    return '$_temp0';
  }

  @override
  String publishedElements(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'elements published',
      one: 'element published',
    );
    return '$_temp0';
  }

  @override
  String get shotDate => 'Capture date';

  @override
  String get publishedDate => 'Published date';

  @override
  String get sendingInProgress => 'Sending in progress…';

  @override
  String get sendingCompleted => 'Sending completed';

  @override
  String get blurringInProgress => 'Blurring in progress';

  @override
  String get actions => 'Actions';

  @override
  String get hidden => 'Hidden sequence';

  @override
  String get errorShare => 'One or more of your pictures do not have a valid date or geolocation. Your sequence could not be imported.';

  @override
  String get settings_title => 'Settings';

  @override
  String get settings_general => 'General';

  @override
  String get settings_sensors => 'Sensors';

  @override
  String get settings_sensors_flash => 'Flash turn on';

  @override
  String get settings_sensors_brightness => 'Reduce brightness during the capture of the sequence';

  @override
  String get settings_sensors_wifi => 'Sent via WiFi only';

  @override
  String get settings_appearance => 'Appearance';

  @override
  String get settings_contact => 'Contact / Help';

  @override
  String get settings_general_language => 'Language';

  @override
  String get settings_general_darkMode => 'Dark mode';

  @override
  String get settings_general_darkMode_light => 'Light';

  @override
  String get settings_general_darkMode_dark => 'Dark';

  @override
  String get settings_general_darkMode_system => 'System';

  @override
  String get settings_logout => 'Log out';

  @override
  String get settings_remote => 'Connectivity';

  @override
  String get settings_instance_choice => 'Instance choice';

  @override
  String settings_instance_field_connection(Object instanceName) {
    return 'Connection to $instanceName';
  }

  @override
  String get settings_instance_field_username => 'Username';

  @override
  String get settings_instance_field_password => 'Password';

  @override
  String get settings_instance_save_error => 'The connection is not possible';

  @override
  String get settings_instance_save_success => 'Connection validated';

  @override
  String get settings_others => 'Others';

  @override
  String get settings_others_logs => 'Logs';

  @override
  String get import_pictures => 'Import photos';

  @override
  String get import_pictures_bad_images_warning => 'One or more of your pictures do not have a valid date or geolocation, they will be ignored';

  @override
  String get capture_tooltip => 'Take a picture';

  @override
  String get singleModeCapture_tooltip => 'Take pictures manually';

  @override
  String get burstModeCapture_tooltip => 'Take pictures automatically';

  @override
  String get createSequenceWithPicture_tooltip => 'Create a new sequence with captured pictures';

  @override
  String get noCameraFoundError => 'No camera found for this device';

  @override
  String get switchCameraRequired => 'Turn your phone to start capturing images';

  @override
  String get photo => 'Photo';

  @override
  String get sequence => 'Sequence';

  @override
  String get permissionLocationRequired => 'You must accept geolocation to be able to use the application';

  @override
  String get permissionCameraRequired => 'You must authorize the camera to take photos';

  @override
  String get goToSettings => 'Go to settings';

  @override
  String get gpsIsDisableContent => 'Please activate your GPS, the application cannot work without it';

  @override
  String get gpsIsDisableTitle => 'GPS disabled';

  @override
  String get goToGpsEnable => 'Activate GPS';

  @override
  String get lowGpsAccuracyTitle => 'Poor GPS accuracy';

  @override
  String get lowGpsAccuracyDesc => 'Move to an outdoor location and wait';

  @override
  String meters(Object count) {
    return '$count m';
  }

  @override
  String get newSequenceNamePreffix => 'Sequence';

  @override
  String get newSequenceNameDateFormat => 'MMM d yy, HH:mm';

  @override
  String get newSequenceNameField => 'Name';

  @override
  String get newSequenceNameField_placeholder => 'Enter the new sequence name';

  @override
  String get newSequenceSendButton => 'Send';

  @override
  String get osmLicenceTitle => 'The photos are freely usable as open data.';

  @override
  String get instanceChoice_title => 'Instance choice';

  @override
  String get osmLicenceDescription => 'Don\'t forget to credit the author of the photo and comply with the terms of the Creative Commons CC-BY-SA 4.0 license.';

  @override
  String get instanceOsmTitle => 'OpenStreetMap France';

  @override
  String get osmGeographicCoverageTitle => 'Photos can be located worldwide';

  @override
  String get osmGeographicCoverageDescription => 'Nevertheless, refrain from sending photos in sensitive areas such as military grounds.';

  @override
  String get ignLicenceTitle => 'The photos are freely usable as open data.';

  @override
  String get ignLicenceDescription => 'Don\'t forget to credit the author of the photo and comply with the terms of the Etalab-2.0 license.';

  @override
  String get instanceIgnTitle => 'Institut national de l\'information géographique et forestière';

  @override
  String get ignGeographicCoverageTitle => 'Photos must be located in France';

  @override
  String get ignGeographicCoverageDescription => 'The photos you submit to the IGN must be taken within French territory (including overseas territories) and outside certain sensitive areas, such as military grounds.';

  @override
  String get newCollectionBack => 'Back to the capture';

  @override
  String newCollectionError(Object errorMessage) {
    return 'Error $errorMessage';
  }

  @override
  String get newCollectionFail => 'Failed to create collection';

  @override
  String get newCollectionUploadSuccess => 'All photos have been exported';

  @override
  String newCollectionLoading(Object count) {
    return 'Sending $count pictures';
  }

  @override
  String get newSequenceAppBarTitle => 'New Collection';

  @override
  String get newSequenceFormLabelText => 'Collection Name';

  @override
  String get newSequenceFormHintText => 'Enter collection name';

  @override
  String get newSequenceFormValidationEmpty => 'Collection name cannot be empty';

  @override
  String nameSerie(Object date) {
    return 'Sequence from $date';
  }

  @override
  String get newSequenceCancel => 'cancel and return to capturing';

  @override
  String get onBoardingSkipButton => 'Skip';

  @override
  String get onBoardingNextButton => 'Next';

  @override
  String get onBoardingCompleteButton => 'Finish';

  @override
  String get onBoardingScreen1Title => 'Share a photo\nof a public place\nin the blink of an eye';

  @override
  String get onBoardingScreen2Title => 'Take photos walking,\ncycling\nor driving';

  @override
  String get onBoardingScreen2SubTitle => 'Long sequences\nto map your city';

  @override
  String get onBoardingScreen3Title => 'Faces and car plates\nare automatically blurred';

  @override
  String get onBoardingScreen4Title => 'Explore millions\nof photos';

  @override
  String get onBoardingScreen4SubTitle => 'Contributors all\nover the world';

  @override
  String get onBoardingScreen5Title => 'Share your photos\nin open data';

  @override
  String get onBoardingScreen5SubTitle => 'Everyone is free\nto use them';

  @override
  String get titleShareUrl => 'Discover my photos 📷 Panoramax';

  @override
  String get calibrationRequiredTitle => 'Recalibration required';

  @override
  String get calibrationInstruction => 'Hold your phone and make a figure-8 motion.';

  @override
  String get appVersionLabel => 'Version';
}

/// The translations for Chinese, using the Han script (`zh_Hant`).
class AppLocalizationsZhHant extends AppLocalizationsZh {
  AppLocalizationsZhHant(): super('zh_Hant');

  @override
  String get common_close => '關閉';

  @override
  String get common_success => '成功';

  @override
  String get common_error => '錯誤';

  @override
  String get common_ok => '確認';

  @override
  String get common_permissionDenied => '權限被拒絕';

  @override
  String get common_dateFormat => 'yy/MM/dd - HH:mm';

  @override
  String get button_submit => '提交';

  @override
  String get yourSequence => '您的序列';

  @override
  String get createSequence_tooltip => '新增序列';

  @override
  String get unknownError => '糟糕！發生錯誤…';

  @override
  String get retry => '重試';

  @override
  String get remoteCollectionRetrieveError => '載入遠端相片時發生錯誤';

  @override
  String get loading => '正在載入…';

  @override
  String get emptyTitle => '幫助我們繪製全世界的地圖！';

  @override
  String get emptySubTitle1 => '🌍 建立獨特的路線。';

  @override
  String get emptyBody1 => '您還沒拍照嗎？\n今天就做出貢獻，建立您周圍街道和景觀的身歷其境視野。';

  @override
  String get emptySubTitle2 => '📸 現在就拍攝您的第一張相片！';

  @override
  String get emptyBody2 => '探索周圍環境，拍照並一起繪製世界地圖。';

  @override
  String get mySequences => '我的相片';

  @override
  String elements(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 個元素',
      one: '1 個元素',
      zero: '沒有元素',
    );
    return '$_temp0';
  }

  @override
  String publishedElements(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '個元素已上傳',
      one: '個元素已上傳',
    );
    return '$_temp0';
  }

  @override
  String get shotDate => '拍攝日期';

  @override
  String get publishedDate => '上傳日期';

  @override
  String get sendingInProgress => '正在上傳…';

  @override
  String get sendingCompleted => '上傳完成';

  @override
  String get blurringInProgress => '正在進行模糊處理';

  @override
  String get actions => '操作';

  @override
  String get hidden => '隱藏序列';

  @override
  String get errorShare => '部分相片缺少有效的日期或位置資訊，無法匯入您的序列。';

  @override
  String get settings_title => '設定';

  @override
  String get settings_general => '一般';

  @override
  String get settings_sensors => '感應器';

  @override
  String get settings_sensors_flash => '打開閃光燈';

  @override
  String get settings_sensors_brightness => '拍攝此序列時減少亮度';

  @override
  String get settings_sensors_wifi => '只透過 WiFi 上傳';

  @override
  String get settings_appearance => '外觀';

  @override
  String get settings_contact => '聯絡 / 說明';

  @override
  String get settings_general_language => '語言';

  @override
  String get settings_general_darkMode => '深色模式';

  @override
  String get settings_general_darkMode_light => '淺色';

  @override
  String get settings_general_darkMode_dark => '深色';

  @override
  String get settings_general_darkMode_system => '系統';

  @override
  String get settings_logout => '登出';

  @override
  String get settings_remote => '連線';

  @override
  String get settings_instance_choice => '選擇執行個體';

  @override
  String settings_instance_field_connection(Object instanceName) {
    return '連線到 $instanceName';
  }

  @override
  String get settings_instance_field_username => '帳號';

  @override
  String get settings_instance_field_password => '密碼';

  @override
  String get settings_instance_save_error => '無法連線';

  @override
  String get settings_instance_save_success => '連線已驗證';

  @override
  String get settings_others => '其他';

  @override
  String get settings_others_logs => '記錄';

  @override
  String get import_pictures => '匯入相片';

  @override
  String get import_pictures_bad_images_warning => '部分相片缺少有效的日期或位置資訊，它們將被略過';

  @override
  String get capture_tooltip => '拍攝相片';

  @override
  String get singleModeCapture_tooltip => '手動拍攝相片';

  @override
  String get burstModeCapture_tooltip => '自動拍攝相片';

  @override
  String get createSequenceWithPicture_tooltip => '使用現有的相片建立序列';

  @override
  String get noCameraFoundError => '在此裝置上找不到相機';

  @override
  String get switchCameraRequired => '旋轉您的手機以開始拍攝相片';

  @override
  String get photo => '相片';

  @override
  String get sequence => '序列';

  @override
  String get permissionLocationRequired => '您必須授予位置權限才能使用此程式';

  @override
  String get permissionCameraRequired => '您必須授予相機權限才能拍攝相片';

  @override
  String get goToSettings => '前往設定';

  @override
  String get gpsIsDisableContent => '請開啟您的 GPS，否則應用程式將無法執行';

  @override
  String get gpsIsDisableTitle => '已停用 GPS';

  @override
  String get goToGpsEnable => '啟用 GPS';

  @override
  String get lowGpsAccuracyTitle => 'GPS 精確度低落';

  @override
  String get lowGpsAccuracyDesc => '前往室外並等待';

  @override
  String meters(Object count) {
    return '$count 公尺';
  }

  @override
  String get newSequenceNamePreffix => '序列';

  @override
  String get newSequenceNameDateFormat => 'yyyy-MM-dd, HH:mm';

  @override
  String get newSequenceNameField => '名稱';

  @override
  String get newSequenceNameField_placeholder => '輸入新序列名稱';

  @override
  String get newSequenceSendButton => '上傳';

  @override
  String get osmLicenceTitle => '這些相片會和開放資料一樣可自由地使用。';

  @override
  String get instanceChoice_title => '選擇執行個體';

  @override
  String get osmLicenceDescription => '不要忘記註明相片作者並遵守創用CC CC-BY-SA 4.0 授權條款。';

  @override
  String get instanceOsmTitle => 'OpenStreetMap 法國';

  @override
  String get osmGeographicCoverageTitle => '接收來自全世界的相片';

  @override
  String get osmGeographicCoverageDescription => '儘管如此，請不要發送軍事基地等敏感地區的相片。';

  @override
  String get ignLicenceTitle => '這些相片會和開放資料一樣可自由地使用。';

  @override
  String get ignLicenceDescription => '不要忘記註明相片作者並遵守 Etalab-2.0 授權條款。';

  @override
  String get instanceIgnTitle => '國家地理與森林資訊研究所';

  @override
  String get ignGeographicCoverageTitle => '相片必須來自法國境內';

  @override
  String get ignGeographicCoverageDescription => '您提交給 IGN 的相片必須在法國境內拍攝 (包含海外領土)，且不得位於某些敏感區域，例如軍事用地。';

  @override
  String get newCollectionBack => '返回相機';

  @override
  String newCollectionError(Object errorMessage) {
    return '錯誤 $errorMessage';
  }

  @override
  String get newCollectionFail => '建立序列失敗';

  @override
  String get newCollectionUploadSuccess => '已上傳所有相片';

  @override
  String newCollectionLoading(Object count) {
    return '正在上傳 $count 張相片';
  }

  @override
  String get newSequenceAppBarTitle => '新增序列';

  @override
  String get newSequenceFormLabelText => '序列名稱';

  @override
  String get newSequenceFormHintText => '輸入序列名稱';

  @override
  String get newSequenceFormValidationEmpty => '序列名稱不可留白';

  @override
  String nameSerie(Object date) {
    return '$date 的序列';
  }

  @override
  String get newSequenceCancel => '取消並返回相機';

  @override
  String get onBoardingSkipButton => '跳過';

  @override
  String get onBoardingNextButton => '下一步';

  @override
  String get onBoardingCompleteButton => '完成';

  @override
  String get onBoardingScreen1Title => '在眨眼間\n分享\n公共場所的相片';

  @override
  String get onBoardingScreen2Title => '在步行、\n騎腳踏車、\n開車時照相';

  @override
  String get onBoardingScreen2SubTitle => '用長序列\n繪製您城市的地圖';

  @override
  String get onBoardingScreen3Title => '自動對臉部和車牌\n做模糊處理';

  @override
  String get onBoardingScreen4Title => '探索\n數百萬張相片';

  @override
  String get onBoardingScreen4SubTitle => '世界各地的\n貢獻者';

  @override
  String get onBoardingScreen5Title => '將您的相片\n分享為開放資料';

  @override
  String get onBoardingScreen5SubTitle => '所有人都可以\n自由地使用它們';

  @override
  String get titleShareUrl => '探索我的相片 📷 Panoramax';
}
