// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Italian (`it`).
class AppLocalizationsIt extends AppLocalizations {
  AppLocalizationsIt([String locale = 'it']) : super(locale);

  @override
  String get common_close => 'Chiudi';

  @override
  String get common_success => 'Successo';

  @override
  String get common_error => 'Errore';

  @override
  String get common_ok => 'Ok';

  @override
  String get common_permissionDenied => 'Permesso rifiutato';

  @override
  String get common_dateFormat => 'yy-MM-dd - HH:mm';

  @override
  String get button_submit => 'Invia';

  @override
  String get yourSequence => 'Le tue sequenze';

  @override
  String get createSequence_tooltip => 'Crea una nuova sequenza';

  @override
  String get unknownError => 'Oops! C’è stato un errore…';

  @override
  String get retry => 'Riprova';

  @override
  String get remoteCollectionRetrieveError => 'Errore durante il caricamento delle foto remote';

  @override
  String get loading => 'Caricamento…';

  @override
  String get emptyTitle => 'Aiutaci a mappare il mondo!';

  @override
  String get emptySubTitle1 => 'Costruisci percorsi unici.';

  @override
  String get emptyBody1 => 'Non hai ancora scattato alcuna foto?\nContribuisci oggi stesso a creare delle viste coinvolgenti delle strade e i paesaggi attorno a te.';

  @override
  String get emptySubTitle2 => '📸 Scatta la tua prima foto adesso!';

  @override
  String get emptyBody2 => 'Esplora il tuo ambiente circostante, scatta una foto e partecipa alla mappatura del mondo.';

  @override
  String get mySequences => 'Le mie foto';

  @override
  String elements(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count elementi',
      one: '1 elemento',
      zero: 'nessun elemento',
    );
    return '$_temp0';
  }

  @override
  String publishedElements(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'elementi pubblicati',
      one: 'elemento pubblicato',
    );
    return '$_temp0';
  }

  @override
  String get shotDate => 'Data dello scatto';

  @override
  String get publishedDate => 'Data di pubblicazione';

  @override
  String get sendingInProgress => 'Invio in corso…';

  @override
  String get sendingCompleted => 'Invio completato';

  @override
  String get blurringInProgress => 'Offuscamento in corso';

  @override
  String get actions => 'Azioni';

  @override
  String get hidden => 'Sequenza nascosta';

  @override
  String get errorShare => 'Una o più delle tue foto è sprovvista di una data o geolocalizzazione validi. La tua sequenza non sarà importata.';

  @override
  String get settings_title => 'Impostazioni';

  @override
  String get settings_general => 'Generale';

  @override
  String get settings_sensors => 'Sensori';

  @override
  String get settings_sensors_flash => 'Accendi il flash';

  @override
  String get settings_sensors_brightness => 'Ridurre la luminosità durante la cattura della sequenza';

  @override
  String get settings_sensors_wifi => 'Invio solo tramite WiFi';

  @override
  String get settings_appearance => 'Aspetto';

  @override
  String get settings_contact => 'Contatto / Aiuto';

  @override
  String get settings_general_language => 'Lingua';

  @override
  String get settings_general_darkMode => 'Modalità scura';

  @override
  String get settings_general_darkMode_light => 'Chiaro';

  @override
  String get settings_general_darkMode_dark => 'Scuro';

  @override
  String get settings_general_darkMode_system => 'Sistema';

  @override
  String get settings_logout => 'Esci';

  @override
  String get settings_remote => 'Connettività';

  @override
  String get settings_instance_choice => 'Scelta dell\'istanza';

  @override
  String settings_instance_field_connection(Object instanceName) {
    return 'Connessione a $instanceName';
  }

  @override
  String get settings_instance_field_username => 'Nome utente';

  @override
  String get settings_instance_field_password => 'Password';

  @override
  String get settings_instance_save_error => 'Connessione non possibile';

  @override
  String get settings_instance_save_success => 'Connessione convalidata';

  @override
  String get settings_others => 'Altri';

  @override
  String get settings_others_logs => 'Log';

  @override
  String get import_pictures => 'Importa foto';

  @override
  String get import_pictures_bad_images_warning => 'Una o più delle tue foto non contengono una data o una geolocalizzazione valide, esse verranno ignorate';

  @override
  String get capture_tooltip => 'Scatta una foto';

  @override
  String get singleModeCapture_tooltip => 'Scatta le foto manualmente';

  @override
  String get burstModeCapture_tooltip => 'Scatta le foto automaticamente';

  @override
  String get createSequenceWithPicture_tooltip => 'Crea una nuova sequenza con le foto scattate';

  @override
  String get noCameraFoundError => 'Nessuna fotocamera trovata per questo dispositivo';

  @override
  String get switchCameraRequired => 'Gira il tuo telefono per iniziare a scattare foto';

  @override
  String get photo => 'Foto';

  @override
  String get sequence => 'Sequenza';

  @override
  String get permissionLocationRequired => 'Per usare questa applicazione è obbligatorio accettare la geolocalizzazione';

  @override
  String get permissionCameraRequired => 'Per scattare foto devi autorizzare l’accesso alla fotocamera';

  @override
  String get goToSettings => 'Vai alle impostazioni';

  @override
  String get gpsIsDisableContent => 'Attiva il tuo GPS, l’applicazione non può funzionare senza di esso';

  @override
  String get gpsIsDisableTitle => 'GPS disabilitato';

  @override
  String get goToGpsEnable => 'Attiva il GPS';

  @override
  String get lowGpsAccuracyTitle => 'Poca accuratezza del GPS';

  @override
  String get lowGpsAccuracyDesc => 'Spostati in una posizione all’esterno e aspetta';

  @override
  String meters(Object count) {
    return '$count m';
  }

  @override
  String get newSequenceNamePreffix => 'Sequenza';

  @override
  String get newSequenceNameDateFormat => 'd MMM yy, HH:mm';

  @override
  String get newSequenceNameField => 'Nome';

  @override
  String get newSequenceNameField_placeholder => 'Inserisci il nome della nuova sequenza';

  @override
  String get newSequenceSendButton => 'Invia';

  @override
  String get osmLicenceTitle => 'Le foto sono liberamente utilizzabili come open data.';

  @override
  String get instanceChoice_title => 'Scelta dell\'istanza';

  @override
  String get osmLicenceDescription => 'Non dimenticarti di citare l’autore della foto e rispettare i termini della licenza Creative Commons CC-BY-SA 4.0.';

  @override
  String get instanceOsmTitle => 'OpenStreetMap France';

  @override
  String get osmGeographicCoverageTitle => 'Le foto possono essere localizzate in tutto il mondo';

  @override
  String get osmGeographicCoverageDescription => 'Evita comunque di inviare foto scattate in aree sensibili come le zone militari.';

  @override
  String get ignLicenceTitle => 'Le foto sono liberamente utilizzabili come open data.';

  @override
  String get ignLicenceDescription => 'Non dimenticarti di citare l’autore della foto e rispettare i termini della licenza Etalab-2.0.';

  @override
  String get instanceIgnTitle => 'Institut national de l\'information géographique et forestière';

  @override
  String get ignGeographicCoverageTitle => 'Le foto devono essere localizzate in Francia';

  @override
  String get ignGeographicCoverageDescription => 'Le foto che invii all’IGN devono essere state scattate nel territorio francese (inclusi i territori oltremare) e al di fuori di aree sensibili, come ad esempio le zone militari.';

  @override
  String get newCollectionBack => 'Torna indietro alla cattura';

  @override
  String newCollectionError(Object errorMessage) {
    return 'Errore $errorMessage';
  }

  @override
  String get newCollectionFail => 'Impossibile creare la collezione';

  @override
  String get newCollectionUploadSuccess => 'Tutte le foto sono state esportate';

  @override
  String newCollectionLoading(Object count) {
    return 'Invio di $count foto in corso';
  }

  @override
  String get newSequenceAppBarTitle => 'Nuova collezione';

  @override
  String get newSequenceFormLabelText => 'Nome della collezione';

  @override
  String get newSequenceFormHintText => 'Inserisci nome della collezione';

  @override
  String get newSequenceFormValidationEmpty => 'Il nome della collezione non può essere vuoto';

  @override
  String nameSerie(Object date) {
    return 'Sequenza del $date';
  }

  @override
  String get newSequenceCancel => 'annulla e ritorna alla cattura';

  @override
  String get onBoardingSkipButton => 'Salta';

  @override
  String get onBoardingNextButton => 'Prossimo';

  @override
  String get onBoardingCompleteButton => 'Termina';

  @override
  String get onBoardingScreen1Title => 'Condividi la foto\ndi un posto pubblico\nin un batter d’occhio';

  @override
  String get onBoardingScreen2Title => 'Scatta delle foto mentre cammini,\npedali\noppure guidi';

  @override
  String get onBoardingScreen2SubTitle => 'Delle lunghe sequenze\nper mappare la tua città';

  @override
  String get onBoardingScreen3Title => 'Le facce e le targhe delle auto\nvengono automaticamente sfocate';

  @override
  String get onBoardingScreen4Title => 'Esplora milioni\ndi foto';

  @override
  String get onBoardingScreen4SubTitle => 'Contributori di\ntutto il mondo';

  @override
  String get onBoardingScreen5Title => 'Condividi le tue foto\nnegli open data';

  @override
  String get onBoardingScreen5SubTitle => 'Chiunque è libero\ndi usarli';

  @override
  String get titleShareUrl => 'Scopri le mie foto 📷 Panoramax';

  @override
  String get calibrationRequiredTitle => 'Recalibration required';

  @override
  String get calibrationInstruction => 'Hold your phone and make a figure-8 motion.';

  @override
  String get appVersionLabel => 'Version';
}
