// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for French (`fr`).
class AppLocalizationsFr extends AppLocalizations {
  AppLocalizationsFr([String locale = 'fr']) : super(locale);

  @override
  String get common_close => 'Fermer';

  @override
  String get common_success => 'Succès';

  @override
  String get common_error => 'Erreur';

  @override
  String get common_ok => 'Ok';

  @override
  String get common_permissionDenied => 'Permission refusée';

  @override
  String get common_dateFormat => 'dd/MM/yy - HH:mm';

  @override
  String get button_submit => 'Valider';

  @override
  String get yourSequence => 'Les séquences';

  @override
  String get createSequence_tooltip => 'Créer une nouvelle séquence';

  @override
  String get unknownError => 'Oups ! Une erreur s\'est produite...';

  @override
  String get retry => 'Réessayer';

  @override
  String get remoteCollectionRetrieveError => 'Erreur lors du chargement des photos distantes';

  @override
  String get loading => 'Chargement…';

  @override
  String get emptyTitle => 'Aidez-nous à cartographier le monde !';

  @override
  String get emptySubTitle1 => '🌍 Construisez des parcours uniques.';

  @override
  String get emptyBody1 => 'Vous n\'avez pas encore capturé de photos ?\nContribuez dès aujourd\'hui à créer des vues immersives des rues et des paysages autour de vous.';

  @override
  String get emptySubTitle2 => '📸 Prenez votre première photo maintenant !';

  @override
  String get emptyBody2 => 'Explorez votre environnement, démarrez une nouvelle séquence et participez à la cartographie du monde.';

  @override
  String get mySequences => 'Mes photos';

  @override
  String elements(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count éléments',
      one: '1 élément',
      zero: 'aucun élément',
    );
    return '$_temp0';
  }

  @override
  String publishedElements(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'éléments publiés',
      one: 'élément publié',
    );
    return '$_temp0';
  }

  @override
  String get shotDate => 'Date de la prise de vue';

  @override
  String get publishedDate => 'Date de publication de la photo';

  @override
  String get sendingInProgress => 'Envoi en cours…';

  @override
  String get sendingCompleted => 'Envoi terminé';

  @override
  String get blurringInProgress => 'Floutage en cours';

  @override
  String get actions => 'Actions';

  @override
  String get hidden => 'Séquence masquée';

  @override
  String get errorShare => 'Une ou plusieurs de vos photos ne comportent pas de date valide ou de géolocalisation. Votre séquence n\'a pas pu être importée.';

  @override
  String get settings_title => 'Paramètres';

  @override
  String get settings_general => 'Général';

  @override
  String get settings_sensors => 'Capteurs';

  @override
  String get settings_sensors_flash => 'Activation du flash';

  @override
  String get settings_sensors_brightness => 'Réduire la luminosité lors de la capture de la séquence';

  @override
  String get settings_sensors_wifi => 'Envoyer via Wi-Fi uniquement';

  @override
  String get settings_appearance => 'Apparence';

  @override
  String get settings_contact => 'Contact / Aide';

  @override
  String get settings_general_language => 'Langue';

  @override
  String get settings_general_darkMode => 'Mode sombre';

  @override
  String get settings_general_darkMode_light => 'Clair';

  @override
  String get settings_general_darkMode_dark => 'Sombre';

  @override
  String get settings_general_darkMode_system => 'Système';

  @override
  String get settings_logout => 'Déconnexion';

  @override
  String get settings_remote => 'Connectivité';

  @override
  String get settings_instance_choice => 'Choix de l\'instance';

  @override
  String settings_instance_field_connection(Object instanceName) {
    return 'Connexion à $instanceName';
  }

  @override
  String get settings_instance_field_username => 'Nom d\'utilisateur';

  @override
  String get settings_instance_field_password => 'Mot de passe';

  @override
  String get settings_instance_save_error => 'La connexion est impossible';

  @override
  String get settings_instance_save_success => 'La connexion est validée';

  @override
  String get settings_others => 'Autres';

  @override
  String get settings_others_logs => 'Logs';

  @override
  String get import_pictures => 'Importer des photos';

  @override
  String get import_pictures_bad_images_warning => 'Une ou plusieurs de vos photos ne comportent pas de date valide ou de géolocalisation, elles seront ignorées';

  @override
  String get capture_tooltip => 'Prendre une photo';

  @override
  String get singleModeCapture_tooltip => 'Prendre des photos manuellement';

  @override
  String get burstModeCapture_tooltip => 'Prendre des photos automatiquement';

  @override
  String get createSequenceWithPicture_tooltip => 'Créer une nouvelle séquence avec les photos prises';

  @override
  String get noCameraFoundError => 'Pas de caméra trouvée pour cet appareil';

  @override
  String get switchCameraRequired => 'Tournez votre téléphone pour commencer la capture d\'images';

  @override
  String get photo => 'Photo';

  @override
  String get sequence => 'Séquence';

  @override
  String get permissionLocationRequired => 'Vous devez obligatoirement accepter la géolocalisation pour pouvoir utiliser l\'application';

  @override
  String get permissionCameraRequired => 'Vous devez obligatoirement autoriser la caméra pour pouvoir prendre des photos';

  @override
  String get goToSettings => 'Aller aux options';

  @override
  String get gpsIsDisableContent => 'Merci d\'activer votre GPS, l\'application ne peut pas fonctionner sans';

  @override
  String get gpsIsDisableTitle => 'GPS non activé';

  @override
  String get goToGpsEnable => 'Activer le GPS';

  @override
  String get lowGpsAccuracyTitle => 'Mauvaise précision de la localisation GPS';

  @override
  String get lowGpsAccuracyDesc => 'Placez-vous en extérieur et patientez';

  @override
  String meters(Object count) {
    return '$count m';
  }

  @override
  String get newSequenceNamePreffix => 'Sequence';

  @override
  String get newSequenceNameDateFormat => 'd MMM yy, HH:mm';

  @override
  String get newSequenceNameField => 'Nom';

  @override
  String get newSequenceNameField_placeholder => 'Saisissez le nom de la nouvelle séquence';

  @override
  String get newSequenceSendButton => 'Envoyer';

  @override
  String get osmLicenceTitle => 'Les photos sont librement utilisables en open data.';

  @override
  String get instanceChoice_title => 'Choix de l\'instance';

  @override
  String get osmLicenceDescription => 'N\'oubliez pas de citer l\'auteur de la photo et respectez les termes de la license Creative Commons CC-BY-SA 4.0.';

  @override
  String get instanceOsmTitle => 'OpenStreetMap France';

  @override
  String get osmGeographicCoverageTitle => 'Les photos peuvent être localisées dans le Monde entier';

  @override
  String get osmGeographicCoverageDescription => 'Abstenez-vous néanmoins d\'envoyer des photos dans les zones sensibles comme les terrains militaires.';

  @override
  String get ignLicenceTitle => 'Les photos sont librement utilisables en open data.';

  @override
  String get ignLicenceDescription => 'N\'oubliez pas de citer l\'auteur de la photo et respectez les termes de la license etalab-2.0.';

  @override
  String get instanceIgnTitle => 'Institut national de l\'information géographique et forestière';

  @override
  String get ignGeographicCoverageTitle => 'Les photos doivent être localisées en France';

  @override
  String get ignGeographicCoverageDescription => 'Les photos que vous envoyez à l\'IGN doivent forcément être prises sur le territoire français (ce qui inclut les territoires ultra-marins) et en dehors de certaines zones sensibles comme les terrains militaires.';

  @override
  String get newCollectionBack => 'Retour à l\'appareil photo';

  @override
  String newCollectionError(Object errorMessage) {
    return 'Erreur $errorMessage';
  }

  @override
  String get newCollectionFail => 'Échec lors de la création de la séquence';

  @override
  String get newCollectionUploadSuccess => 'Toutes les photos ont été envoyées';

  @override
  String newCollectionLoading(Object count) {
    return 'Envoi en cours $count photos';
  }

  @override
  String get newSequenceAppBarTitle => 'Nouvelle séquence';

  @override
  String get newSequenceFormLabelText => 'Nom de la séquence';

  @override
  String get newSequenceFormHintText => 'Saisissez le nom de la séquence';

  @override
  String get newSequenceFormValidationEmpty => 'Le nom de la séquence ne peut pas être vide';

  @override
  String nameSerie(Object date) {
    return 'Séquence du $date';
  }

  @override
  String get newSequenceCancel => 'annuler et revenir à la prise de vue';

  @override
  String get onBoardingSkipButton => 'Passer';

  @override
  String get onBoardingNextButton => 'Suivant';

  @override
  String get onBoardingCompleteButton => 'Terminer';

  @override
  String get onBoardingScreen1Title => 'Partagez la photo\nd\'un lieu public\nen un clin d\'œil';

  @override
  String get onBoardingScreen2Title => 'Prenez des photos\nà pied, en vélo\nou en voiture';

  @override
  String get onBoardingScreen2SubTitle => 'Des séquences longues\npour cartographier votre ville';

  @override
  String get onBoardingScreen3Title => 'Les visages et plaques\nd\'immatriculation sont\nautomatiquement floutés';

  @override
  String get onBoardingScreen4Title => 'Explorer des millions\nde photos';

  @override
  String get onBoardingScreen4SubTitle => 'Des contributeurs\ndans le monde entier';

  @override
  String get onBoardingScreen5Title => 'Partagez vos photos\nen open data';

  @override
  String get onBoardingScreen5SubTitle => 'Chacun peut librement\nen faire usage';

  @override
  String get titleShareUrl => 'Découvrez mes photos 📷 Panoramax';

  @override
  String get calibrationRequiredTitle => 'Recalibrage nécessaire';

  @override
  String get calibrationInstruction => 'Tenez votre téléphone et faites un mouvement en forme de 8.';

  @override
  String get appVersionLabel => 'Version';
}
