// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Esperanto (`eo`).
class AppLocalizationsEo extends AppLocalizations {
  AppLocalizationsEo([String locale = 'eo']) : super(locale);

  @override
  String get common_close => 'Fermi';

  @override
  String get common_success => 'Sukceso';

  @override
  String get common_error => 'Eraro';

  @override
  String get common_ok => 'Bone';

  @override
  String get common_permissionDenied => 'Permeso rifuzita';

  @override
  String get common_dateFormat => 'yy/MM/dd - HH:mm';

  @override
  String get button_submit => 'Sendi';

  @override
  String get yourSequence => 'Viaj sekvencoj';

  @override
  String get createSequence_tooltip => 'Krei novan sekvencon';

  @override
  String get unknownError => 'Ho ve! Eraro okazis…';

  @override
  String get retry => 'Reprovi';

  @override
  String get remoteCollectionRetrieveError => 'Eraro dum ŝargado de foraj fotoj';

  @override
  String get loading => 'Ŝarganto…';

  @override
  String get emptyTitle => 'Helpu nin mapi la mondon!';

  @override
  String get emptySubTitle1 => '🌍 Konstruu unikajn vojojn.';

  @override
  String get emptyBody1 => 'Ĉu vi ankoraŭ ne kaptis foton?\nKontribuu hodiaŭ por krei enmergajn vidojn de la stratoj kaj pejzaĝoj ĉirkaŭ vi.';

  @override
  String get emptySubTitle2 => '📸 Faru vian unuan foton nun!';

  @override
  String get emptyBody2 => 'Esploru vian ĉirkaŭaĵon, faru foton kaj partoprenu en la mapado de la mondo.';

  @override
  String get mySequences => 'Miaj fotoj';

  @override
  String elements(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count elementoj',
      one: '1 elemento',
      zero: 'neniu elemento',
    );
    return '$_temp0';
  }

  @override
  String publishedElements(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'elementoj publikigitaj',
      one: 'elemento publikigita',
    );
    return '$_temp0';
  }

  @override
  String get shotDate => 'Fotada dato';

  @override
  String get publishedDate => 'Publikiga dato';

  @override
  String get sendingInProgress => 'Sendado faratante…';

  @override
  String get sendingCompleted => 'Sendado finita';

  @override
  String get blurringInProgress => 'Malklarigado farata';

  @override
  String get actions => 'Agoj';

  @override
  String get hidden => 'Maskita sekvenco';

  @override
  String get errorShare => 'Unu aŭ pluraj el viaj bildoj ne havas validan daton aŭ geolokon. Via sekvenco ne povis esti importita.';

  @override
  String get settings_title => 'Agordoj';

  @override
  String get settings_general => 'Ĝenerala';

  @override
  String get settings_sensors => 'Sensiloj';

  @override
  String get settings_sensors_flash => 'Fulmo ŝaltita';

  @override
  String get settings_sensors_brightness => 'Redukti brilecon dum la kaptado de la sekvenco';

  @override
  String get settings_sensors_wifi => 'Sendi nur per WiFi';

  @override
  String get settings_appearance => 'Aspekto';

  @override
  String get settings_contact => 'Kontakto / Helpo';

  @override
  String get settings_general_language => 'Lingvo';

  @override
  String get settings_general_darkMode => 'Malhela reĝimo';

  @override
  String get settings_general_darkMode_light => 'Hela';

  @override
  String get settings_general_darkMode_dark => 'Malhela';

  @override
  String get settings_general_darkMode_system => 'Sistemo';

  @override
  String get settings_logout => 'Elsaluti';

  @override
  String get settings_remote => 'Konektebleco';

  @override
  String get settings_instance_choice => 'Elektado de instanco';

  @override
  String settings_instance_field_connection(Object instanceName) {
    return 'Konekto al $instanceName';
  }

  @override
  String get settings_instance_field_username => 'Uzantnomo';

  @override
  String get settings_instance_field_password => 'Pasvorto';

  @override
  String get settings_instance_save_error => 'La konekto ne eblas';

  @override
  String get settings_instance_save_success => 'Konekto validigita';

  @override
  String get settings_others => 'Aliaj';

  @override
  String get settings_others_logs => 'Logs';

  @override
  String get import_pictures => 'Importi fotojn';

  @override
  String get import_pictures_bad_images_warning => 'Unu aŭ pluraj el viaj fotoj ne havas validan daton aŭ geolokon, ili estos ignoritaj';

  @override
  String get capture_tooltip => 'Fari foton';

  @override
  String get singleModeCapture_tooltip => 'Fari fotojn mane';

  @override
  String get burstModeCapture_tooltip => 'Fari fotojn aŭtomate';

  @override
  String get createSequenceWithPicture_tooltip => 'Krei novan sekvencon kun kaptitaj fotoj';

  @override
  String get noCameraFoundError => 'Neniu fotilo trovita por ĉi tiu aparato';

  @override
  String get switchCameraRequired => 'Turnu vian telefonon por komenci kapti bildojn';

  @override
  String get photo => 'Foto';

  @override
  String get sequence => 'Sekvenco';

  @override
  String get permissionLocationRequired => 'Vi devas akcepti geolokon por povi uzi la aplikaĵon';

  @override
  String get permissionCameraRequired => 'Vi devas permesi la fotilon por fari fotojn';

  @override
  String get goToSettings => 'Iri al agordoj';

  @override
  String get gpsIsDisableContent => 'Bonvolu aktivigi vian GPS-on, la aplikaĵo ne povas funkcii sen ĝi';

  @override
  String get gpsIsDisableTitle => 'GPS malŝaltita';

  @override
  String get goToGpsEnable => 'Aktivigi GPS-on';

  @override
  String get lowGpsAccuracyTitle => 'Malbona GPS-precizeco';

  @override
  String get lowGpsAccuracyDesc => 'Movu vin al eksteraj lokoj kaj atendu';

  @override
  String meters(Object count) {
    return '$count m';
  }

  @override
  String get newSequenceNamePreffix => 'Sekvenco';

  @override
  String get newSequenceNameDateFormat => 'd MMM yy, HH:mm';

  @override
  String get newSequenceNameField => 'Nomo';

  @override
  String get newSequenceNameField_placeholder => 'Enigu la novan sekvencnomon';

  @override
  String get newSequenceSendButton => 'Sendi';

  @override
  String get osmLicenceTitle => 'La fotoj estas libere uzeblaj kiel malfermaj datumoj.';

  @override
  String get instanceChoice_title => 'Elektado de instanco';

  @override
  String get osmLicenceDescription => 'Ne forgesu kredi la aŭtoron de la foto kaj sekvi la kondiĉojn de la Creative Commons CC-BY-SA 4.0 permesilo.';

  @override
  String get instanceOsmTitle => 'OpenStreetMap Francio';

  @override
  String get osmGeographicCoverageTitle => 'Fotoj povas esti lokitaj tutmonde';

  @override
  String get osmGeographicCoverageDescription => 'Tamen, ne sendu fotojn en sentemaj areoj kiel armeaj zonoj.';

  @override
  String get ignLicenceTitle => 'La fotoj estas libere uzeblaj kiel malfermaj datumoj.';

  @override
  String get ignLicenceDescription => 'Ne forgesu kredi la aŭtoron de la foto kaj sekvi la kondiĉojn de la Etalab-2.0 permesilo.';

  @override
  String get instanceIgnTitle => 'Nacia Instituto pri Geografia kaj Arbara Informo';

  @override
  String get ignGeographicCoverageTitle => 'Fotoj devas esti lokitaj en Francio';

  @override
  String get ignGeographicCoverageDescription => 'La fotoj, kiujn vi sendas al la IGN, devas esti prenitaj ene de la franca teritorio (inkluzive de transmaraj teritorioj) kaj ekster certaj sentemaj areoj, kiel armeaj zonoj.';

  @override
  String get newCollectionBack => 'Reiri al la fotilo';

  @override
  String newCollectionError(Object errorMessage) {
    return 'Eraro $errorMessage';
  }

  @override
  String get newCollectionFail => 'Malsukcesis krei sekvencon';

  @override
  String get newCollectionUploadSuccess => 'Ĉiuj fotoj estis eksportitaj';

  @override
  String newCollectionLoading(Object count) {
    return 'Sendante $count bildojn';
  }

  @override
  String get newSequenceAppBarTitle => 'Nova sekvenco';

  @override
  String get newSequenceFormLabelText => 'Nomo de la sekvenco';

  @override
  String get newSequenceFormHintText => 'Enigu sekvencan nomon';

  @override
  String get newSequenceFormValidationEmpty => 'Sekvencan nomon ne povas esti malplena';

  @override
  String nameSerie(Object date) {
    return 'Sekvenco de $date';
  }

  @override
  String get newSequenceCancel => 'Nuligi kaj reveni al fotado';

  @override
  String get onBoardingSkipButton => 'Pretersalti';

  @override
  String get onBoardingNextButton => 'Sekva';

  @override
  String get onBoardingCompleteButton => 'Fini';

  @override
  String get onBoardingScreen1Title => 'Kunhavigu foton\nde publika loko\nen la palpebrumo de okulo';

  @override
  String get onBoardingScreen2Title => 'Prenu fotojn promenante,\nbiciklante\naŭ veturante';

  @override
  String get onBoardingScreen2SubTitle => 'Longaj sekvencoj\npor mapigi vian urbon';

  @override
  String get onBoardingScreen3Title => 'Vizaĝoj kaj aŭtokentabuloj\nestas aŭtomate nebuliĝigitaj';

  @override
  String get onBoardingScreen4Title => 'Esploru milionojn\nda fotoj';

  @override
  String get onBoardingScreen4SubTitle => 'Kontribuantoj tra\nla tuta mondo';

  @override
  String get onBoardingScreen5Title => 'Kunhavigu viajn fotojn\nkiel malfermitaj datumoj';

  @override
  String get onBoardingScreen5SubTitle => 'Ĉiuj rajtas\nuzi ilin libere';

  @override
  String get titleShareUrl => 'Malkovru miajn fotojn 📷 Panoramax';

  @override
  String get calibrationRequiredTitle => 'Recalibration required';

  @override
  String get calibrationInstruction => 'Hold your phone and make a figure-8 motion.';

  @override
  String get appVersionLabel => 'Version';
}
