// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for English (`en`).
class AppLocalizationsEn extends AppLocalizations {
  AppLocalizationsEn([String locale = 'en']) : super(locale);

  @override
  String get common_close => 'Close';

  @override
  String get common_success => 'Success';

  @override
  String get common_error => 'Error';

  @override
  String get common_ok => 'Ok';

  @override
  String get common_permissionDenied => 'Permission denied';

  @override
  String get common_dateFormat => 'yy/MM/dd - HH:mm';

  @override
  String get button_submit => 'Submit';

  @override
  String get yourSequence => 'Your sequences';

  @override
  String get createSequence_tooltip => 'Create a new sequence';

  @override
  String get unknownError => 'Oops ! An error occurred…';

  @override
  String get retry => 'Retry';

  @override
  String get remoteCollectionRetrieveError => 'Error when loading remote photos';

  @override
  String get loading => 'Loading…';

  @override
  String get emptyTitle => 'Help us map the world!';

  @override
  String get emptySubTitle1 => '🌍 Build unique routes.';

  @override
  String get emptyBody1 => 'You haven\'t captured photo yet?\nContribute today to create immersive views of the streets and landscapes around you.';

  @override
  String get emptySubTitle2 => '📸 Take your first photo now!';

  @override
  String get emptyBody2 => 'Explore your surroundings, take a photo and take part in mapping the world.';

  @override
  String get mySequences => 'My pictures';

  @override
  String elements(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count elements',
      one: '1 element',
      zero: 'no element',
    );
    return '$_temp0';
  }

  @override
  String publishedElements(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'elements published',
      one: 'element published',
    );
    return '$_temp0';
  }

  @override
  String get shotDate => 'Capture date';

  @override
  String get publishedDate => 'Published date';

  @override
  String get sendingInProgress => 'Sending in progress…';

  @override
  String get sendingCompleted => 'Sending completed';

  @override
  String get blurringInProgress => 'Blurring in progress';

  @override
  String get actions => 'Actions';

  @override
  String get hidden => 'Hidden sequence';

  @override
  String get errorShare => 'One or more of your pictures do not have a valid date or geolocation. Your sequence could not be imported.';

  @override
  String get settings_title => 'Settings';

  @override
  String get settings_general => 'General';

  @override
  String get settings_sensors => 'Sensors';

  @override
  String get settings_sensors_flash => 'Flash turn on';

  @override
  String get settings_sensors_brightness => 'Reduce brightness during the capture of the sequence';

  @override
  String get settings_sensors_wifi => 'Sent via WiFi only';

  @override
  String get settings_appearance => 'Appearance';

  @override
  String get settings_contact => 'Contact / Help';

  @override
  String get settings_general_language => 'Language';

  @override
  String get settings_general_darkMode => 'Dark mode';

  @override
  String get settings_general_darkMode_light => 'Light';

  @override
  String get settings_general_darkMode_dark => 'Dark';

  @override
  String get settings_general_darkMode_system => 'System';

  @override
  String get settings_logout => 'Log out';

  @override
  String get settings_remote => 'Connectivity';

  @override
  String get settings_instance_choice => 'Instance choice';

  @override
  String settings_instance_field_connection(Object instanceName) {
    return 'Connection to $instanceName';
  }

  @override
  String get settings_instance_field_username => 'Username';

  @override
  String get settings_instance_field_password => 'Password';

  @override
  String get settings_instance_save_error => 'The connection is not possible';

  @override
  String get settings_instance_save_success => 'Connection validated';

  @override
  String get settings_others => 'Others';

  @override
  String get settings_others_logs => 'Logs';

  @override
  String get import_pictures => 'Import photos';

  @override
  String get import_pictures_bad_images_warning => 'One or more of your pictures do not have a valid date or geolocation, they will be ignored';

  @override
  String get capture_tooltip => 'Take a picture';

  @override
  String get singleModeCapture_tooltip => 'Take pictures manually';

  @override
  String get burstModeCapture_tooltip => 'Take pictures automatically';

  @override
  String get createSequenceWithPicture_tooltip => 'Create a new sequence with captured pictures';

  @override
  String get noCameraFoundError => 'No camera found for this device';

  @override
  String get switchCameraRequired => 'Turn your phone to start capturing images';

  @override
  String get photo => 'Photo';

  @override
  String get sequence => 'Sequence';

  @override
  String get permissionLocationRequired => 'You must accept geolocation to be able to use the application';

  @override
  String get permissionCameraRequired => 'You must authorize the camera to take photos';

  @override
  String get goToSettings => 'Go to settings';

  @override
  String get gpsIsDisableContent => 'Please activate your GPS, the application cannot work without it';

  @override
  String get gpsIsDisableTitle => 'GPS disabled';

  @override
  String get goToGpsEnable => 'Activate GPS';

  @override
  String get lowGpsAccuracyTitle => 'Poor GPS accuracy';

  @override
  String get lowGpsAccuracyDesc => 'Move to an outdoor location and wait';

  @override
  String meters(Object count) {
    return '$count m';
  }

  @override
  String get newSequenceNamePreffix => 'Sequence';

  @override
  String get newSequenceNameDateFormat => 'MMM d yy, HH:mm';

  @override
  String get newSequenceNameField => 'Name';

  @override
  String get newSequenceNameField_placeholder => 'Enter the new sequence name';

  @override
  String get newSequenceSendButton => 'Send';

  @override
  String get osmLicenceTitle => 'The photos are freely usable as open data.';

  @override
  String get instanceChoice_title => 'Instance choice';

  @override
  String get osmLicenceDescription => 'Don\'t forget to credit the author of the photo and comply with the terms of the Creative Commons CC-BY-SA 4.0 license.';

  @override
  String get instanceOsmTitle => 'OpenStreetMap France';

  @override
  String get osmGeographicCoverageTitle => 'Photos can be located worldwide';

  @override
  String get osmGeographicCoverageDescription => 'Nevertheless, refrain from sending photos in sensitive areas such as military grounds.';

  @override
  String get ignLicenceTitle => 'The photos are freely usable as open data.';

  @override
  String get ignLicenceDescription => 'Don\'t forget to credit the author of the photo and comply with the terms of the Etalab-2.0 license.';

  @override
  String get instanceIgnTitle => 'Institut national de l\'information géographique et forestière';

  @override
  String get ignGeographicCoverageTitle => 'Photos must be located in France';

  @override
  String get ignGeographicCoverageDescription => 'The photos you submit to the IGN must be taken within French territory (including overseas territories) and outside certain sensitive areas, such as military grounds.';

  @override
  String get newCollectionBack => 'Back to the capture';

  @override
  String newCollectionError(Object errorMessage) {
    return 'Error $errorMessage';
  }

  @override
  String get newCollectionFail => 'Failed to create collection';

  @override
  String get newCollectionUploadSuccess => 'All photos have been exported';

  @override
  String newCollectionLoading(Object count) {
    return 'Sending $count pictures';
  }

  @override
  String get newSequenceAppBarTitle => 'New Collection';

  @override
  String get newSequenceFormLabelText => 'Collection Name';

  @override
  String get newSequenceFormHintText => 'Enter collection name';

  @override
  String get newSequenceFormValidationEmpty => 'Collection name cannot be empty';

  @override
  String nameSerie(Object date) {
    return 'Sequence from $date';
  }

  @override
  String get newSequenceCancel => 'cancel and return to capturing';

  @override
  String get onBoardingSkipButton => 'Skip';

  @override
  String get onBoardingNextButton => 'Next';

  @override
  String get onBoardingCompleteButton => 'Finish';

  @override
  String get onBoardingScreen1Title => 'Share a photo\nof a public place\nin the blink of an eye';

  @override
  String get onBoardingScreen2Title => 'Take photos walking,\ncycling\nor driving';

  @override
  String get onBoardingScreen2SubTitle => 'Long sequences\nto map your city';

  @override
  String get onBoardingScreen3Title => 'Faces and car plates\nare automatically blurred';

  @override
  String get onBoardingScreen4Title => 'Explore millions\nof photos';

  @override
  String get onBoardingScreen4SubTitle => 'Contributors all\nover the world';

  @override
  String get onBoardingScreen5Title => 'Share your photos\nin open data';

  @override
  String get onBoardingScreen5SubTitle => 'Everyone is free\nto use them';

  @override
  String get titleShareUrl => 'Discover my photos 📷 Panoramax';

  @override
  String get calibrationRequiredTitle => 'Recalibration required';

  @override
  String get calibrationInstruction => 'Hold your phone and make a figure-8 motion.';

  @override
  String get appVersionLabel => 'Version';
}
