// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for German (`de`).
class AppLocalizationsDe extends AppLocalizations {
  AppLocalizationsDe([String locale = 'de']) : super(locale);

  @override
  String get common_close => 'Schliessen';

  @override
  String get common_success => 'Erfolg';

  @override
  String get common_error => 'Fehler';

  @override
  String get common_ok => 'Okay';

  @override
  String get common_permissionDenied => 'Zugriff verweigert';

  @override
  String get common_dateFormat => 'dd.MM.yy - HH:mm';

  @override
  String get button_submit => 'Senden';

  @override
  String get yourSequence => 'Ihre Sequenzen';

  @override
  String get createSequence_tooltip => 'Neue Sequenz erstellen';

  @override
  String get unknownError => 'Ups! Ein Fehler ist aufgetreten…';

  @override
  String get retry => 'Wiederholen';

  @override
  String get remoteCollectionRetrieveError => 'Fehler beim Laden der Remote-Fotos';

  @override
  String get loading => 'Lade…';

  @override
  String get emptyTitle => 'Helfen sie uns die Welt zu kartieren!';

  @override
  String get emptySubTitle1 => '🌍 Einzigartige Routen erstellen.';

  @override
  String get emptyBody1 => 'Sie haven noch kein Foto aufgenommen?\nTragen sie heute zu immersiven Ansichten von Strassen und Landschaften um sie herum bei.';

  @override
  String get emptySubTitle2 => '📸 Nehmen sie jetzt ihr erstes Foto auf!';

  @override
  String get emptyBody2 => 'Erkunden sie ihre Umgebung, machen sie ein Foto und tragen sie dazu bei die Welt zu kartieren.';

  @override
  String get mySequences => 'Meine Fotos';

  @override
  String elements(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Elemente',
      one: '1 Element',
      zero: 'Kein Element',
    );
    return '$_temp0';
  }

  @override
  String publishedElements(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Elemente veröffentlicht',
      one: 'Element veröffentlicht',
    );
    return '$_temp0';
  }

  @override
  String get shotDate => 'Aufnahmedatum';

  @override
  String get publishedDate => 'Veröffentlichungsdatum';

  @override
  String get sendingInProgress => 'Wird versendet…';

  @override
  String get sendingCompleted => 'Versand komplett';

  @override
  String get blurringInProgress => 'Unkenntlichmachung in Bearbeitung';

  @override
  String get actions => 'Aktionen';

  @override
  String get hidden => 'Versteckte Sequenz';

  @override
  String get errorShare => 'Eines oder mehrere Fotos haben kein valides Datum oder keine valide Geolokalisierung. Ihre Sequenz konnte nicht importiert werden.';

  @override
  String get settings_title => 'Einstellungen';

  @override
  String get settings_general => 'Allgemein';

  @override
  String get settings_sensors => 'Sensoren';

  @override
  String get settings_sensors_flash => 'Blitz angeschaltet';

  @override
  String get settings_sensors_brightness => 'Reduzieren sie die Helligkeit während der Aufnahme der Sequenz';

  @override
  String get settings_sensors_wifi => 'Nur über WLAN senden';

  @override
  String get settings_appearance => 'Aussehen';

  @override
  String get settings_contact => 'Kontakt / Hilfe';

  @override
  String get settings_general_language => 'Sprache';

  @override
  String get settings_general_darkMode => 'Darkmode';

  @override
  String get settings_general_darkMode_light => 'Hell';

  @override
  String get settings_general_darkMode_dark => 'Dunkel';

  @override
  String get settings_general_darkMode_system => 'System';

  @override
  String get settings_logout => 'Abmelden';

  @override
  String get settings_remote => 'Verbindung';

  @override
  String get settings_instance_choice => 'Wahl der Instanz';

  @override
  String settings_instance_field_connection(Object instanceName) {
    return 'Zu $instanceName verbinden';
  }

  @override
  String get settings_instance_field_username => 'Benutzername';

  @override
  String get settings_instance_field_password => 'Passwort';

  @override
  String get settings_instance_save_error => 'Verbindung ist nicht möglich';

  @override
  String get settings_instance_save_success => 'Verbindung validiert';

  @override
  String get settings_others => 'Andere';

  @override
  String get settings_others_logs => 'Log';

  @override
  String get import_pictures => 'Fotos importieren';

  @override
  String get import_pictures_bad_images_warning => 'Eines oder mehrere ihrer Fotos haben kein valides Datum oder valide Geolokalisation, sie werden ignoriert werden';

  @override
  String get capture_tooltip => 'Foto aufnehmen';

  @override
  String get singleModeCapture_tooltip => 'Manuell Fotos aufnehmen';

  @override
  String get burstModeCapture_tooltip => 'Automatisch Fotos aufnehmen';

  @override
  String get createSequenceWithPicture_tooltip => 'Neue Sequenz mit aufgenommenen Bildern erstellen';

  @override
  String get noCameraFoundError => 'Keine Kamera auf diesem Gerät gefunden';

  @override
  String get switchCameraRequired => 'Schalten sie ihr Telefon ein um mit der Aufnahme von Fotos zu beginnen';

  @override
  String get photo => 'Foto';

  @override
  String get sequence => 'Sequenz';

  @override
  String get permissionLocationRequired => 'Sie müssen die Geolokalisierung akzeptieren um diese Applikation zu verwenden';

  @override
  String get permissionCameraRequired => 'Sie müssen die Kamerabenutzung autorisieren um Fotos aufzunehmen';

  @override
  String get goToSettings => 'Zu Einstellungen gehen';

  @override
  String get gpsIsDisableContent => 'Bitte aktivieren sie ihr GPS, die Applikation kann ohne es nicht funktionieren';

  @override
  String get gpsIsDisableTitle => 'GPS deaktiviert';

  @override
  String get goToGpsEnable => 'GPS aktivieren';

  @override
  String get lowGpsAccuracyTitle => 'Schlechte GPS-Genauigkeit';

  @override
  String get lowGpsAccuracyDesc => 'Bewegen sie sich nach draussen und warten sie';

  @override
  String meters(Object count) {
    return '$count m';
  }

  @override
  String get newSequenceNamePreffix => 'Sequenz';

  @override
  String get newSequenceNameDateFormat => 'd MMM yy, H:m';

  @override
  String get newSequenceNameField => 'Name';

  @override
  String get newSequenceNameField_placeholder => 'Neuen Sequenznamen eingeben';

  @override
  String get newSequenceSendButton => 'Absenden';

  @override
  String get osmLicenceTitle => 'Die Fotos sind als offene Daten frei verwendbar.';

  @override
  String get instanceChoice_title => 'Instanzwahl';

  @override
  String get osmLicenceDescription => 'Vergessen sie nicht den Autor des Fotos zu nennen und halten sie die Bedingungen der Creative Commons CC BY-SA 4.0 Lizenz ein.';

  @override
  String get instanceOsmTitle => 'OpenstreetMap France';

  @override
  String get osmGeographicCoverageTitle => 'Fotos können weltweit aufgenommen worden sein';

  @override
  String get osmGeographicCoverageDescription => 'Trotzdem, unterlassen sie es Fotos von sensitiven Bereichen wie Militärinstallationen hochzuladen.';

  @override
  String get ignLicenceTitle => 'Die Fotos sind als offene Daten frei nutzbar.';

  @override
  String get ignLicenceDescription => 'Vergessen sie nicht den Autor zu nennen und halten sie die Etalab-2.0 Lizenz ein.';

  @override
  String get instanceIgnTitle => 'Nationales Institut für Geografie und Forstwirtschaft';

  @override
  String get ignGeographicCoverageTitle => 'Fotos müssen in Frankreich aufgenommen sein';

  @override
  String get ignGeographicCoverageDescription => 'Die Fotos die sie zu IGN hochladen müssen auf französischem Gebiet (inklusive der Überseeterritorien) und ausserhalb von sensitiven Einrichtungen wie Militärgebieten aufgenommen worden sein.';

  @override
  String get newCollectionBack => 'Zurück zur Aufnahme';

  @override
  String newCollectionError(Object errorMessage) {
    return 'Fehler $errorMessage';
  }

  @override
  String get newCollectionFail => 'Erstellung der Kollektion fehlgeschlagen';

  @override
  String get newCollectionUploadSuccess => 'Alle Fotos wurden exportiert';

  @override
  String newCollectionLoading(Object count) {
    return 'Lade $count Fotos hoch';
  }

  @override
  String get newSequenceAppBarTitle => 'Neue Kollektion';

  @override
  String get newSequenceFormLabelText => 'Kollektionsname';

  @override
  String get newSequenceFormHintText => 'Geben sie einen Kollektionsnamen ein';

  @override
  String get newSequenceFormValidationEmpty => 'Kollektionsname kann nicht leer sein';

  @override
  String nameSerie(Object date) {
    return 'Sequenz vom $date';
  }

  @override
  String get newSequenceCancel => 'Abbrechen und zurück zur Aufnahme';

  @override
  String get onBoardingSkipButton => 'Überspringen';

  @override
  String get onBoardingNextButton => 'Nächstes';

  @override
  String get onBoardingCompleteButton => 'Beenden';

  @override
  String get onBoardingScreen1Title => 'Teilen sie ein Foto\neines öffentlichen Ortes\nim Handumdrehen';

  @override
  String get onBoardingScreen2Title => 'Nehmen sie Fotos laufend,\nradfahrend, oder\nautofahrend auf';

  @override
  String get onBoardingScreen2SubTitle => 'Lange Sequenzen um \nihre Stadt zu kartografieren';

  @override
  String get onBoardingScreen3Title => 'Gesichter und Nummernschilder\nwerden automatisch unkenntlich gemacht';

  @override
  String get onBoardingScreen4Title => 'Entdecken sie \nMillionen von Fotos';

  @override
  String get onBoardingScreen4SubTitle => 'Tragen sie überall\nauf der Welt bei';

  @override
  String get onBoardingScreen5Title => 'Teilen sie ihre Fotos\nals offene Daten';

  @override
  String get onBoardingScreen5SubTitle => 'Alle können sie\nfrei verwenden';

  @override
  String get titleShareUrl => 'Entdecke meine Fotos 📷 Panoramax';

  @override
  String get calibrationRequiredTitle => 'Recalibration required';

  @override
  String get calibrationInstruction => 'Hold your phone and make a figure-8 motion.';

  @override
  String get appVersionLabel => 'Version';
}
