// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Danish (`da`).
class AppLocalizationsDa extends AppLocalizations {
  AppLocalizationsDa([String locale = 'da']) : super(locale);

  @override
  String get common_close => 'Luk';

  @override
  String get common_success => 'Succes';

  @override
  String get common_error => 'Fejl';

  @override
  String get common_ok => 'Ok';

  @override
  String get common_permissionDenied => 'Tilladelse nægtet';

  @override
  String get common_dateFormat => 'yy-MM-dd - HH:mm';

  @override
  String get button_submit => 'Indsend';

  @override
  String get yourSequence => 'Dine sekvenser';

  @override
  String get createSequence_tooltip => 'Opret en ny sekvens';

  @override
  String get unknownError => 'Ups! Der opstod en fejl…';

  @override
  String get retry => 'Prøv igen';

  @override
  String get remoteCollectionRetrieveError => 'Fejl ved indlæsning af eksterne fotos';

  @override
  String get loading => 'Indlæser…';

  @override
  String get emptyTitle => 'Hjælp os med at kortlægge verden!';

  @override
  String get emptySubTitle1 => '🌍 Byg unikke ruter.';

  @override
  String get emptyBody1 => 'Har du ikke taget et foto endnu?\nBidrag i dag for at skabe detaljerede visninger af gaderne og landskaberne omkring dig.';

  @override
  String get emptySubTitle2 => '📸 Tag dit første foto nu!';

  @override
  String get emptyBody2 => 'Udforsk dine omgivelser, tag et foto, og vær med til at kortlægge verden.';

  @override
  String get mySequences => 'Mine billeder';

  @override
  String elements(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count elementer',
      one: '1 element',
      zero: 'intet element',
    );
    return '$_temp0';
  }

  @override
  String publishedElements(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'elementer offentliggjort',
      one: 'element offentliggjort',
    );
    return '$_temp0';
  }

  @override
  String get shotDate => 'Optagelsesdato';

  @override
  String get publishedDate => 'Udgivelsesdato';

  @override
  String get sendingInProgress => 'Afsendelse i gang…';

  @override
  String get sendingCompleted => 'Afsendelse gennemført';

  @override
  String get blurringInProgress => 'Sløring i gang';

  @override
  String get actions => 'Handlinger';

  @override
  String get hidden => 'Skjult sekvens';

  @override
  String get errorShare => 'En eller flere af dine billeder har ikke en gyldig dato eller geolokation. Din sekvens kunne ikke importeres.';

  @override
  String get settings_title => 'Indstillinger';

  @override
  String get settings_general => 'Generelt';

  @override
  String get settings_sensors => 'Sensorer';

  @override
  String get settings_sensors_flash => 'Tænd for blitz';

  @override
  String get settings_sensors_brightness => 'Reducer lysstyrken under optagelsen af sekvensen';

  @override
  String get settings_sensors_wifi => 'Send kun via WiFi';

  @override
  String get settings_appearance => 'Udseende';

  @override
  String get settings_contact => 'Kontakt / Hjælp';

  @override
  String get settings_general_language => 'Sprog';

  @override
  String get settings_general_darkMode => 'Mørk tilstand';

  @override
  String get settings_general_darkMode_light => 'Lys';

  @override
  String get settings_general_darkMode_dark => 'Mørk';

  @override
  String get settings_general_darkMode_system => 'System';

  @override
  String get settings_logout => 'Log ud';

  @override
  String get settings_remote => 'Forbindelse';

  @override
  String get settings_instance_choice => 'Instance valg';

  @override
  String settings_instance_field_connection(Object instanceName) {
    return 'Forbindelse til $instanceName';
  }

  @override
  String get settings_instance_field_username => 'Brugernavn';

  @override
  String get settings_instance_field_password => 'Adgangskode';

  @override
  String get settings_instance_save_error => 'Forbindelsen er ikke mulig';

  @override
  String get settings_instance_save_success => 'Forbindelsen er bekræftet';

  @override
  String get settings_others => 'Andre';

  @override
  String get settings_others_logs => 'Logs';

  @override
  String get import_pictures => 'Importer fotos';

  @override
  String get import_pictures_bad_images_warning => 'Et eller flere af dine billeder har ikke en gyldig dato eller geolokation, de vil blive ignoreret';

  @override
  String get capture_tooltip => 'Tag et billede';

  @override
  String get singleModeCapture_tooltip => 'Tag billeder manuelt';

  @override
  String get burstModeCapture_tooltip => 'Tag billeder automatisk';

  @override
  String get createSequenceWithPicture_tooltip => 'Opret en ny sekvens med optagne billeder';

  @override
  String get noCameraFoundError => 'Intet kamera fundet for denne enhed';

  @override
  String get switchCameraRequired => 'Drej din telefon for at begynde at tage billeder';

  @override
  String get photo => 'Foto';

  @override
  String get sequence => 'Sekvens';

  @override
  String get permissionLocationRequired => 'Du skal acceptere geolokation for at bruge applikationen';

  @override
  String get permissionCameraRequired => 'Du skal give kameraet tilladelse til at tage fotos';

  @override
  String get goToSettings => 'Gå til indstillinger';

  @override
  String get gpsIsDisableContent => 'Aktivér din GPS, applikationen kan ikke fungere uden';

  @override
  String get gpsIsDisableTitle => 'GPS deaktiveret';

  @override
  String get goToGpsEnable => 'Aktivér GPS';

  @override
  String get lowGpsAccuracyTitle => 'Dårlig GPS-nøjagtighed';

  @override
  String get lowGpsAccuracyDesc => 'Flyt dig til et udendørs sted og vent';

  @override
  String meters(Object count) {
    return '$count m';
  }

  @override
  String get newSequenceNamePreffix => 'Sekvens';

  @override
  String get newSequenceNameDateFormat => 'd MMM yy, HH:mm';

  @override
  String get newSequenceNameField => 'Navn';

  @override
  String get newSequenceNameField_placeholder => 'Indtast det nye sekvensnavn';

  @override
  String get newSequenceSendButton => 'Send';

  @override
  String get osmLicenceTitle => 'Fotografierne kan frit bruges som åbne data.';

  @override
  String get instanceChoice_title => 'Valg af instans';

  @override
  String get osmLicenceDescription => 'Glem ikke at kreditere ophavsmanden til fotoet og overholde betingelserne i Creative Commons CC-BY-SA 4.0-licensen.';

  @override
  String get instanceOsmTitle => 'OpenStreetMap Frankrig';

  @override
  String get osmGeographicCoverageTitle => 'Fotos kan findes i hele verden';

  @override
  String get osmGeographicCoverageDescription => 'Lad dog være med at sende fotos i følsomme områder som f.eks. militærområder.';

  @override
  String get ignLicenceTitle => 'Fotografierne kan frit bruges som åbne data.';

  @override
  String get ignLicenceDescription => 'Glem ikke at kreditere ophavsmanden til fotoet og overholde betingelserne i Etalab-2.0-licensen.';

  @override
  String get instanceIgnTitle => 'Institut national de l\'information géographique et forestière';

  @override
  String get ignGeographicCoverageTitle => 'Fotos skal være placeret i Frankrig';

  @override
  String get ignGeographicCoverageDescription => 'De fotos, du sender til IGN, skal være taget inden for fransk territorium (inklusive oversøiske territorier) og uden for visse følsomme områder, f.eks. militærområder.';

  @override
  String get newCollectionBack => 'Tilbage til optagelsen';

  @override
  String newCollectionError(Object errorMessage) {
    return 'Fejl $errorMessage';
  }

  @override
  String get newCollectionFail => 'Kunne ikke oprette samling';

  @override
  String get newCollectionUploadSuccess => 'Alle fotos er blevet eksporteret';

  @override
  String newCollectionLoading(Object count) {
    return 'Sender $count billeder';
  }

  @override
  String get newSequenceAppBarTitle => 'Ny samling';

  @override
  String get newSequenceFormLabelText => 'Samlingens navn';

  @override
  String get newSequenceFormHintText => 'Indtast samlingens navn';

  @override
  String get newSequenceFormValidationEmpty => 'Samlingsnavnet må ikke være tomt';

  @override
  String nameSerie(Object date) {
    return 'Sekvens fra $date';
  }

  @override
  String get newSequenceCancel => 'annullér og vend tilbage til optagelse';

  @override
  String get onBoardingSkipButton => 'Spring over';

  @override
  String get onBoardingNextButton => 'Næste';

  @override
  String get onBoardingCompleteButton => 'Færdig';

  @override
  String get onBoardingScreen1Title => 'Del et foto\naf et offentligt sted\npå et øjeblik';

  @override
  String get onBoardingScreen2Title => 'Tag fotos på gåben,\npå cykel\neller i bil';

  @override
  String get onBoardingScreen2SubTitle => 'Lange sekvenser\ntil at kortlægge din by';

  @override
  String get onBoardingScreen3Title => 'Ansigter og nummerplader\nbliver automatisk sløret';

  @override
  String get onBoardingScreen4Title => 'Udforsk millioner\naf fotos';

  @override
  String get onBoardingScreen4SubTitle => 'Bidrag over\nhele verden';

  @override
  String get onBoardingScreen5Title => 'Del dine fotos\ni åbne data';

  @override
  String get onBoardingScreen5SubTitle => 'Alle kan frit\nbruge dem';

  @override
  String get titleShareUrl => 'Se mine fotos 📷 Panoramax';

  @override
  String get calibrationRequiredTitle => 'Recalibration required';

  @override
  String get calibrationInstruction => 'Hold your phone and make a figure-8 motion.';

  @override
  String get appVersionLabel => 'Version';
}
