import 'dart:async';

import 'package:flutter/foundation.dart';
import 'package:flutter/widgets.dart';
import 'package:flutter_localizations/flutter_localizations.dart';
import 'package:intl/intl.dart' as intl;

import 'app_localizations_br.dart';
import 'app_localizations_da.dart';
import 'app_localizations_de.dart';
import 'app_localizations_en.dart';
import 'app_localizations_eo.dart';
import 'app_localizations_fr.dart';
import 'app_localizations_it.dart';
import 'app_localizations_zh.dart';

// ignore_for_file: type=lint

/// Callers can lookup localized strings with an instance of AppLocalizations
/// returned by `AppLocalizations.of(context)`.
///
/// Applications need to include `AppLocalizations.delegate()` in their app's
/// `localizationDelegates` list, and the locales they support in the app's
/// `supportedLocales` list. For example:
///
/// ```dart
/// import 'gen_l10n/app_localizations.dart';
///
/// return MaterialApp(
///   localizationsDelegates: AppLocalizations.localizationsDelegates,
///   supportedLocales: AppLocalizations.supportedLocales,
///   home: MyApplicationHome(),
/// );
/// ```
///
/// ## Update pubspec.yaml
///
/// Please make sure to update your pubspec.yaml to include the following
/// packages:
///
/// ```yaml
/// dependencies:
///   # Internationalization support.
///   flutter_localizations:
///     sdk: flutter
///   intl: any # Use the pinned version from flutter_localizations
///
///   # Rest of dependencies
/// ```
///
/// ## iOS Applications
///
/// iOS applications define key application metadata, including supported
/// locales, in an Info.plist file that is built into the application bundle.
/// To configure the locales supported by your app, you’ll need to edit this
/// file.
///
/// First, open your project’s ios/Runner.xcworkspace Xcode workspace file.
/// Then, in the Project Navigator, open the Info.plist file under the Runner
/// project’s Runner folder.
///
/// Next, select the Information Property List item, select Add Item from the
/// Editor menu, then select Localizations from the pop-up menu.
///
/// Select and expand the newly-created Localizations item then, for each
/// locale your application supports, add a new item and select the locale
/// you wish to add from the pop-up menu in the Value field. This list should
/// be consistent with the languages listed in the AppLocalizations.supportedLocales
/// property.
abstract class AppLocalizations {
  AppLocalizations(String locale) : localeName = intl.Intl.canonicalizedLocale(locale.toString());

  final String localeName;

  static AppLocalizations? of(BuildContext context) {
    return Localizations.of<AppLocalizations>(context, AppLocalizations);
  }

  static const LocalizationsDelegate<AppLocalizations> delegate = _AppLocalizationsDelegate();

  /// A list of this localizations delegate along with the default localizations
  /// delegates.
  ///
  /// Returns a list of localizations delegates containing this delegate along with
  /// GlobalMaterialLocalizations.delegate, GlobalCupertinoLocalizations.delegate,
  /// and GlobalWidgetsLocalizations.delegate.
  ///
  /// Additional delegates can be added by appending to this list in
  /// MaterialApp. This list does not have to be used at all if a custom list
  /// of delegates is preferred or required.
  static const List<LocalizationsDelegate<dynamic>> localizationsDelegates = <LocalizationsDelegate<dynamic>>[
    delegate,
    GlobalMaterialLocalizations.delegate,
    GlobalCupertinoLocalizations.delegate,
    GlobalWidgetsLocalizations.delegate,
  ];

  /// A list of this localizations delegate's supported locales.
  static const List<Locale> supportedLocales = <Locale>[
    Locale('br'),
    Locale('da'),
    Locale('de'),
    Locale('en'),
    Locale('eo'),
    Locale('fr'),
    Locale('it'),
    Locale('zh'),
    Locale.fromSubtags(languageCode: 'zh', scriptCode: 'Hant')
  ];

  /// No description provided for @common_close.
  ///
  /// In en, this message translates to:
  /// **'Close'**
  String get common_close;

  /// No description provided for @common_success.
  ///
  /// In en, this message translates to:
  /// **'Success'**
  String get common_success;

  /// No description provided for @common_error.
  ///
  /// In en, this message translates to:
  /// **'Error'**
  String get common_error;

  /// No description provided for @common_ok.
  ///
  /// In en, this message translates to:
  /// **'Ok'**
  String get common_ok;

  /// No description provided for @common_permissionDenied.
  ///
  /// In en, this message translates to:
  /// **'Permission denied'**
  String get common_permissionDenied;

  /// No description provided for @common_dateFormat.
  ///
  /// In en, this message translates to:
  /// **'yy/MM/dd - HH:mm'**
  String get common_dateFormat;

  /// No description provided for @button_submit.
  ///
  /// In en, this message translates to:
  /// **'Submit'**
  String get button_submit;

  /// No description provided for @yourSequence.
  ///
  /// In en, this message translates to:
  /// **'Your sequences'**
  String get yourSequence;

  /// No description provided for @createSequence_tooltip.
  ///
  /// In en, this message translates to:
  /// **'Create a new sequence'**
  String get createSequence_tooltip;

  /// No description provided for @unknownError.
  ///
  /// In en, this message translates to:
  /// **'Oops ! An error occurred…'**
  String get unknownError;

  /// No description provided for @retry.
  ///
  /// In en, this message translates to:
  /// **'Retry'**
  String get retry;

  /// No description provided for @remoteCollectionRetrieveError.
  ///
  /// In en, this message translates to:
  /// **'Error when loading remote photos'**
  String get remoteCollectionRetrieveError;

  /// No description provided for @loading.
  ///
  /// In en, this message translates to:
  /// **'Loading…'**
  String get loading;

  /// No description provided for @emptyTitle.
  ///
  /// In en, this message translates to:
  /// **'Help us map the world!'**
  String get emptyTitle;

  /// No description provided for @emptySubTitle1.
  ///
  /// In en, this message translates to:
  /// **'🌍 Build unique routes.'**
  String get emptySubTitle1;

  /// No description provided for @emptyBody1.
  ///
  /// In en, this message translates to:
  /// **'You haven\'t captured photo yet?\nContribute today to create immersive views of the streets and landscapes around you.'**
  String get emptyBody1;

  /// No description provided for @emptySubTitle2.
  ///
  /// In en, this message translates to:
  /// **'📸 Take your first photo now!'**
  String get emptySubTitle2;

  /// No description provided for @emptyBody2.
  ///
  /// In en, this message translates to:
  /// **'Explore your surroundings, take a photo and take part in mapping the world.'**
  String get emptyBody2;

  /// No description provided for @mySequences.
  ///
  /// In en, this message translates to:
  /// **'My pictures'**
  String get mySequences;

  /// No description provided for @elements.
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =0{no element} =1{1 element} other{{count} elements}}'**
  String elements(num count);

  /// No description provided for @publishedElements.
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =1{element published} other{elements published}}'**
  String publishedElements(num count);

  /// No description provided for @shotDate.
  ///
  /// In en, this message translates to:
  /// **'Capture date'**
  String get shotDate;

  /// No description provided for @publishedDate.
  ///
  /// In en, this message translates to:
  /// **'Published date'**
  String get publishedDate;

  /// No description provided for @sendingInProgress.
  ///
  /// In en, this message translates to:
  /// **'Sending in progress…'**
  String get sendingInProgress;

  /// No description provided for @sendingCompleted.
  ///
  /// In en, this message translates to:
  /// **'Sending completed'**
  String get sendingCompleted;

  /// No description provided for @blurringInProgress.
  ///
  /// In en, this message translates to:
  /// **'Blurring in progress'**
  String get blurringInProgress;

  /// No description provided for @actions.
  ///
  /// In en, this message translates to:
  /// **'Actions'**
  String get actions;

  /// No description provided for @hidden.
  ///
  /// In en, this message translates to:
  /// **'Hidden sequence'**
  String get hidden;

  /// No description provided for @errorShare.
  ///
  /// In en, this message translates to:
  /// **'One or more of your pictures do not have a valid date or geolocation. Your sequence could not be imported.'**
  String get errorShare;

  /// No description provided for @settings_title.
  ///
  /// In en, this message translates to:
  /// **'Settings'**
  String get settings_title;

  /// No description provided for @settings_general.
  ///
  /// In en, this message translates to:
  /// **'General'**
  String get settings_general;

  /// No description provided for @settings_sensors.
  ///
  /// In en, this message translates to:
  /// **'Sensors'**
  String get settings_sensors;

  /// No description provided for @settings_sensors_flash.
  ///
  /// In en, this message translates to:
  /// **'Flash turn on'**
  String get settings_sensors_flash;

  /// No description provided for @settings_sensors_brightness.
  ///
  /// In en, this message translates to:
  /// **'Reduce brightness during the capture of the sequence'**
  String get settings_sensors_brightness;

  /// No description provided for @settings_sensors_wifi.
  ///
  /// In en, this message translates to:
  /// **'Sent via WiFi only'**
  String get settings_sensors_wifi;

  /// No description provided for @settings_appearance.
  ///
  /// In en, this message translates to:
  /// **'Appearance'**
  String get settings_appearance;

  /// No description provided for @settings_contact.
  ///
  /// In en, this message translates to:
  /// **'Contact / Help'**
  String get settings_contact;

  /// No description provided for @settings_general_language.
  ///
  /// In en, this message translates to:
  /// **'Language'**
  String get settings_general_language;

  /// No description provided for @settings_general_darkMode.
  ///
  /// In en, this message translates to:
  /// **'Dark mode'**
  String get settings_general_darkMode;

  /// No description provided for @settings_general_darkMode_light.
  ///
  /// In en, this message translates to:
  /// **'Light'**
  String get settings_general_darkMode_light;

  /// No description provided for @settings_general_darkMode_dark.
  ///
  /// In en, this message translates to:
  /// **'Dark'**
  String get settings_general_darkMode_dark;

  /// No description provided for @settings_general_darkMode_system.
  ///
  /// In en, this message translates to:
  /// **'System'**
  String get settings_general_darkMode_system;

  /// No description provided for @settings_logout.
  ///
  /// In en, this message translates to:
  /// **'Log out'**
  String get settings_logout;

  /// No description provided for @settings_remote.
  ///
  /// In en, this message translates to:
  /// **'Connectivity'**
  String get settings_remote;

  /// No description provided for @settings_instance_choice.
  ///
  /// In en, this message translates to:
  /// **'Instance choice'**
  String get settings_instance_choice;

  /// No description provided for @settings_instance_field_connection.
  ///
  /// In en, this message translates to:
  /// **'Connection to {instanceName}'**
  String settings_instance_field_connection(Object instanceName);

  /// No description provided for @settings_instance_field_username.
  ///
  /// In en, this message translates to:
  /// **'Username'**
  String get settings_instance_field_username;

  /// No description provided for @settings_instance_field_password.
  ///
  /// In en, this message translates to:
  /// **'Password'**
  String get settings_instance_field_password;

  /// No description provided for @settings_instance_save_error.
  ///
  /// In en, this message translates to:
  /// **'The connection is not possible'**
  String get settings_instance_save_error;

  /// No description provided for @settings_instance_save_success.
  ///
  /// In en, this message translates to:
  /// **'Connection validated'**
  String get settings_instance_save_success;

  /// No description provided for @settings_others.
  ///
  /// In en, this message translates to:
  /// **'Others'**
  String get settings_others;

  /// No description provided for @settings_others_logs.
  ///
  /// In en, this message translates to:
  /// **'Logs'**
  String get settings_others_logs;

  /// No description provided for @import_pictures.
  ///
  /// In en, this message translates to:
  /// **'Import photos'**
  String get import_pictures;

  /// No description provided for @import_pictures_bad_images_warning.
  ///
  /// In en, this message translates to:
  /// **'One or more of your pictures do not have a valid date or geolocation, they will be ignored'**
  String get import_pictures_bad_images_warning;

  /// No description provided for @capture_tooltip.
  ///
  /// In en, this message translates to:
  /// **'Take a picture'**
  String get capture_tooltip;

  /// No description provided for @singleModeCapture_tooltip.
  ///
  /// In en, this message translates to:
  /// **'Take pictures manually'**
  String get singleModeCapture_tooltip;

  /// No description provided for @burstModeCapture_tooltip.
  ///
  /// In en, this message translates to:
  /// **'Take pictures automatically'**
  String get burstModeCapture_tooltip;

  /// No description provided for @createSequenceWithPicture_tooltip.
  ///
  /// In en, this message translates to:
  /// **'Create a new sequence with captured pictures'**
  String get createSequenceWithPicture_tooltip;

  /// No description provided for @noCameraFoundError.
  ///
  /// In en, this message translates to:
  /// **'No camera found for this device'**
  String get noCameraFoundError;

  /// No description provided for @switchCameraRequired.
  ///
  /// In en, this message translates to:
  /// **'Turn your phone to start capturing images'**
  String get switchCameraRequired;

  /// No description provided for @photo.
  ///
  /// In en, this message translates to:
  /// **'Photo'**
  String get photo;

  /// No description provided for @sequence.
  ///
  /// In en, this message translates to:
  /// **'Sequence'**
  String get sequence;

  /// No description provided for @permissionLocationRequired.
  ///
  /// In en, this message translates to:
  /// **'You must accept geolocation to be able to use the application'**
  String get permissionLocationRequired;

  /// No description provided for @permissionCameraRequired.
  ///
  /// In en, this message translates to:
  /// **'You must authorize the camera to take photos'**
  String get permissionCameraRequired;

  /// No description provided for @goToSettings.
  ///
  /// In en, this message translates to:
  /// **'Go to settings'**
  String get goToSettings;

  /// No description provided for @gpsIsDisableContent.
  ///
  /// In en, this message translates to:
  /// **'Please activate your GPS, the application cannot work without it'**
  String get gpsIsDisableContent;

  /// No description provided for @gpsIsDisableTitle.
  ///
  /// In en, this message translates to:
  /// **'GPS disabled'**
  String get gpsIsDisableTitle;

  /// No description provided for @goToGpsEnable.
  ///
  /// In en, this message translates to:
  /// **'Activate GPS'**
  String get goToGpsEnable;

  /// No description provided for @lowGpsAccuracyTitle.
  ///
  /// In en, this message translates to:
  /// **'Poor GPS accuracy'**
  String get lowGpsAccuracyTitle;

  /// No description provided for @lowGpsAccuracyDesc.
  ///
  /// In en, this message translates to:
  /// **'Move to an outdoor location and wait'**
  String get lowGpsAccuracyDesc;

  /// No description provided for @meters.
  ///
  /// In en, this message translates to:
  /// **'{count} m'**
  String meters(Object count);

  /// No description provided for @newSequenceNamePreffix.
  ///
  /// In en, this message translates to:
  /// **'Sequence'**
  String get newSequenceNamePreffix;

  /// No description provided for @newSequenceNameDateFormat.
  ///
  /// In en, this message translates to:
  /// **'MMM d yy, HH:mm'**
  String get newSequenceNameDateFormat;

  /// No description provided for @newSequenceNameField.
  ///
  /// In en, this message translates to:
  /// **'Name'**
  String get newSequenceNameField;

  /// No description provided for @newSequenceNameField_placeholder.
  ///
  /// In en, this message translates to:
  /// **'Enter the new sequence name'**
  String get newSequenceNameField_placeholder;

  /// No description provided for @newSequenceSendButton.
  ///
  /// In en, this message translates to:
  /// **'Send'**
  String get newSequenceSendButton;

  /// No description provided for @osmLicenceTitle.
  ///
  /// In en, this message translates to:
  /// **'The photos are freely usable as open data.'**
  String get osmLicenceTitle;

  /// No description provided for @instanceChoice_title.
  ///
  /// In en, this message translates to:
  /// **'Instance choice'**
  String get instanceChoice_title;

  /// No description provided for @osmLicenceDescription.
  ///
  /// In en, this message translates to:
  /// **'Don\'t forget to credit the author of the photo and comply with the terms of the Creative Commons CC-BY-SA 4.0 license.'**
  String get osmLicenceDescription;

  /// No description provided for @instanceOsmTitle.
  ///
  /// In en, this message translates to:
  /// **'OpenStreetMap France'**
  String get instanceOsmTitle;

  /// No description provided for @osmGeographicCoverageTitle.
  ///
  /// In en, this message translates to:
  /// **'Photos can be located worldwide'**
  String get osmGeographicCoverageTitle;

  /// No description provided for @osmGeographicCoverageDescription.
  ///
  /// In en, this message translates to:
  /// **'Nevertheless, refrain from sending photos in sensitive areas such as military grounds.'**
  String get osmGeographicCoverageDescription;

  /// No description provided for @ignLicenceTitle.
  ///
  /// In en, this message translates to:
  /// **'The photos are freely usable as open data.'**
  String get ignLicenceTitle;

  /// No description provided for @ignLicenceDescription.
  ///
  /// In en, this message translates to:
  /// **'Don\'t forget to credit the author of the photo and comply with the terms of the Etalab-2.0 license.'**
  String get ignLicenceDescription;

  /// No description provided for @instanceIgnTitle.
  ///
  /// In en, this message translates to:
  /// **'Institut national de l\'information géographique et forestière'**
  String get instanceIgnTitle;

  /// No description provided for @ignGeographicCoverageTitle.
  ///
  /// In en, this message translates to:
  /// **'Photos must be located in France'**
  String get ignGeographicCoverageTitle;

  /// No description provided for @ignGeographicCoverageDescription.
  ///
  /// In en, this message translates to:
  /// **'The photos you submit to the IGN must be taken within French territory (including overseas territories) and outside certain sensitive areas, such as military grounds.'**
  String get ignGeographicCoverageDescription;

  /// No description provided for @newCollectionBack.
  ///
  /// In en, this message translates to:
  /// **'Back to the capture'**
  String get newCollectionBack;

  /// No description provided for @newCollectionError.
  ///
  /// In en, this message translates to:
  /// **'Error {errorMessage}'**
  String newCollectionError(Object errorMessage);

  /// No description provided for @newCollectionFail.
  ///
  /// In en, this message translates to:
  /// **'Failed to create collection'**
  String get newCollectionFail;

  /// No description provided for @newCollectionUploadSuccess.
  ///
  /// In en, this message translates to:
  /// **'All photos have been exported'**
  String get newCollectionUploadSuccess;

  /// No description provided for @newCollectionLoading.
  ///
  /// In en, this message translates to:
  /// **'Sending {count} pictures'**
  String newCollectionLoading(Object count);

  /// No description provided for @newSequenceAppBarTitle.
  ///
  /// In en, this message translates to:
  /// **'New Collection'**
  String get newSequenceAppBarTitle;

  /// No description provided for @newSequenceFormLabelText.
  ///
  /// In en, this message translates to:
  /// **'Collection Name'**
  String get newSequenceFormLabelText;

  /// No description provided for @newSequenceFormHintText.
  ///
  /// In en, this message translates to:
  /// **'Enter collection name'**
  String get newSequenceFormHintText;

  /// No description provided for @newSequenceFormValidationEmpty.
  ///
  /// In en, this message translates to:
  /// **'Collection name cannot be empty'**
  String get newSequenceFormValidationEmpty;

  /// No description provided for @nameSerie.
  ///
  /// In en, this message translates to:
  /// **'Sequence from {date}'**
  String nameSerie(Object date);

  /// No description provided for @newSequenceCancel.
  ///
  /// In en, this message translates to:
  /// **'cancel and return to capturing'**
  String get newSequenceCancel;

  /// No description provided for @onBoardingSkipButton.
  ///
  /// In en, this message translates to:
  /// **'Skip'**
  String get onBoardingSkipButton;

  /// No description provided for @onBoardingNextButton.
  ///
  /// In en, this message translates to:
  /// **'Next'**
  String get onBoardingNextButton;

  /// No description provided for @onBoardingCompleteButton.
  ///
  /// In en, this message translates to:
  /// **'Finish'**
  String get onBoardingCompleteButton;

  /// No description provided for @onBoardingScreen1Title.
  ///
  /// In en, this message translates to:
  /// **'Share a photo\nof a public place\nin the blink of an eye'**
  String get onBoardingScreen1Title;

  /// No description provided for @onBoardingScreen2Title.
  ///
  /// In en, this message translates to:
  /// **'Take photos walking,\ncycling\nor driving'**
  String get onBoardingScreen2Title;

  /// No description provided for @onBoardingScreen2SubTitle.
  ///
  /// In en, this message translates to:
  /// **'Long sequences\nto map your city'**
  String get onBoardingScreen2SubTitle;

  /// No description provided for @onBoardingScreen3Title.
  ///
  /// In en, this message translates to:
  /// **'Faces and car plates\nare automatically blurred'**
  String get onBoardingScreen3Title;

  /// No description provided for @onBoardingScreen4Title.
  ///
  /// In en, this message translates to:
  /// **'Explore millions\nof photos'**
  String get onBoardingScreen4Title;

  /// No description provided for @onBoardingScreen4SubTitle.
  ///
  /// In en, this message translates to:
  /// **'Contributors all\nover the world'**
  String get onBoardingScreen4SubTitle;

  /// No description provided for @onBoardingScreen5Title.
  ///
  /// In en, this message translates to:
  /// **'Share your photos\nin open data'**
  String get onBoardingScreen5Title;

  /// No description provided for @onBoardingScreen5SubTitle.
  ///
  /// In en, this message translates to:
  /// **'Everyone is free\nto use them'**
  String get onBoardingScreen5SubTitle;

  /// No description provided for @titleShareUrl.
  ///
  /// In en, this message translates to:
  /// **'Discover my photos 📷 Panoramax'**
  String get titleShareUrl;

  /// No description provided for @calibrationRequiredTitle.
  ///
  /// In en, this message translates to:
  /// **'Recalibration required'**
  String get calibrationRequiredTitle;

  /// No description provided for @calibrationInstruction.
  ///
  /// In en, this message translates to:
  /// **'Hold your phone and make a figure-8 motion.'**
  String get calibrationInstruction;

  /// No description provided for @appVersionLabel.
  ///
  /// In en, this message translates to:
  /// **'Version'**
  String get appVersionLabel;
}

class _AppLocalizationsDelegate extends LocalizationsDelegate<AppLocalizations> {
  const _AppLocalizationsDelegate();

  @override
  Future<AppLocalizations> load(Locale locale) {
    return SynchronousFuture<AppLocalizations>(lookupAppLocalizations(locale));
  }

  @override
  bool isSupported(Locale locale) => <String>['br', 'da', 'de', 'en', 'eo', 'fr', 'it', 'zh'].contains(locale.languageCode);

  @override
  bool shouldReload(_AppLocalizationsDelegate old) => false;
}

AppLocalizations lookupAppLocalizations(Locale locale) {

  // Lookup logic when language+script codes are specified.
  switch (locale.languageCode) {
    case 'zh': {
  switch (locale.scriptCode) {
    case 'Hant': return AppLocalizationsZhHant();
   }
  break;
   }
  }

  // Lookup logic when only language code is specified.
  switch (locale.languageCode) {
    case 'br': return AppLocalizationsBr();
    case 'da': return AppLocalizationsDa();
    case 'de': return AppLocalizationsDe();
    case 'en': return AppLocalizationsEn();
    case 'eo': return AppLocalizationsEo();
    case 'fr': return AppLocalizationsFr();
    case 'it': return AppLocalizationsIt();
    case 'zh': return AppLocalizationsZh();
  }

  throw FlutterError(
    'AppLocalizations.delegate failed to load unsupported locale "$locale". This is likely '
    'an issue with the localizations generation tool. Please file an issue '
    'on GitHub with a reproducible sample app and the gen-l10n configuration '
    'that was used.'
  );
}
