import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';

LargeButtonStyle(Color color) => FilledButton.styleFrom(
  iconSize: 20,
  minimumSize: Size(150, 50),
  foregroundColor: color,
  textStyle: TextStyle(
    fontSize: 20,
    fontWeight: FontWeight.w700
  )
);

class AtomicFilledButton extends StatelessWidget {
  final String text;
  final IconData icon;
  final String? tooltip;
  final VoidCallback? callback;
  final ButtonStyle? style;
  final Color? color;

  const AtomicFilledButton.base({
    super.key,
    required this.text,
    required this.icon,
    required this.callback,
    this.tooltip,
    this.style,
    this.color
  });

  @override
  Widget build(BuildContext context) {
    final button =  FilledButton.icon(
      icon: Icon(this.icon, color: this.color),
      onPressed: callback,
      label: Text(text),
      style: style,
    );
    return tooltip != null ? Tooltip(message: tooltip, child: button) : button;
  }

  @override
  void debugFillProperties(DiagnosticPropertiesBuilder properties) {
    super.debugFillProperties(properties);
    properties.add(StringProperty('text', text));
    properties.add(DiagnosticsProperty<IconData>('icon', icon));
    properties.add(StringProperty('tooltip', tooltip));
    properties.add(ObjectFlagProperty<VoidCallback?>.has('callback', callback));
    properties.add(DiagnosticsProperty<ButtonStyle?>('style', style));
    properties.add(ColorProperty('color', color));
  }
}
