import 'package:flutter/foundation.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:get_it/get_it.dart';
import 'package:panoramax_mobile/main.dart';


/// Usage: the app is running with locale {'en'}
Future<void> theAppIsRunningWithLocale(WidgetTester tester) async {
  try {
    GetIt.instance.registerLazySingleton<NavigationService>(() => NavigationService());
  } on Exception catch (e) {
    if (kDebugMode) {
      print(e);
    }
  } finally {
    await tester.pumpWidget(const PanoramaxApp());
    GetIt.instance<NavigationService>().pushTo(Routes.homepage);
  }
}
