package com.panoramax.app

import android.os.Bundle
import io.flutter.embedding.android.FlutterActivity
import io.flutter.plugin.common.EventChannel
import io.flutter.plugin.common.MethodChannel

class MainActivity : FlutterActivity() {

    private val GPS_STREAM = "app.panoramax.beta/gps_location_stream"
    private val CALIBRATION_STREAM = "app.panoramax.beta/magnetometer_calibration"

    private lateinit var gpsLocationHelper: GpsLocationHelper
    private lateinit var magnetometerCalibrationHelper: MagnetometerCalibrationHelper

    override fun configureFlutterEngine(flutterEngine: io.flutter.embedding.engine.FlutterEngine) {
        super.configureFlutterEngine(flutterEngine)

        // Init helpers
        gpsLocationHelper = GpsLocationHelper(this)
        magnetometerCalibrationHelper = MagnetometerCalibrationHelper(this)

        // GPS location stream
        EventChannel(flutterEngine.dartExecutor.binaryMessenger, GPS_STREAM)
            .setStreamHandler(gpsLocationHelper)

        // Magnetometer calibration
        EventChannel(flutterEngine.dartExecutor.binaryMessenger, CALIBRATION_STREAM)
            .setStreamHandler(magnetometerCalibrationHelper)
    }
}
