package com.panoramax.app

import android.content.Context
import android.hardware.Sensor
import android.hardware.SensorEvent
import android.hardware.SensorEventListener
import android.hardware.SensorManager
import io.flutter.plugin.common.EventChannel

class MagnetometerCalibrationHelper(
    context: Context
) : EventChannel.StreamHandler, SensorEventListener {

    private val sensorManager: SensorManager =
        context.getSystemService(Context.SENSOR_SERVICE) as SensorManager
    private val magneticSensor: Sensor? = sensorManager.getDefaultSensor(Sensor.TYPE_MAGNETIC_FIELD)

    private var eventSink: EventChannel.EventSink? = null
    private var currentAccuracy: Int = SensorManager.SENSOR_STATUS_UNRELIABLE

    override fun onListen(arguments: Any?, sink: EventChannel.EventSink?) {
        eventSink = sink
        magneticSensor?.let {
            sensorManager.registerListener(this, it, SensorManager.SENSOR_DELAY_UI)
            emitCalibrationStatus(currentAccuracy)
        }
    }

    override fun onCancel(arguments: Any?) {
        sensorManager.unregisterListener(this)
        eventSink = null
    }

    override fun onSensorChanged(event: SensorEvent?) {
    }

    override fun onAccuracyChanged(sensor: Sensor?, accuracy: Int) {
        if (sensor?.type == Sensor.TYPE_MAGNETIC_FIELD) {
            if (accuracy != currentAccuracy) {
                currentAccuracy = accuracy
                emitCalibrationStatus(currentAccuracy)
            }
        }
    }

    private fun emitCalibrationStatus(accuracy: Int) {
        val status = when (accuracy) {
            SensorManager.SENSOR_STATUS_UNRELIABLE -> "unreliable"
            SensorManager.SENSOR_STATUS_ACCURACY_LOW -> "accuracy_low"
            SensorManager.SENSOR_STATUS_ACCURACY_MEDIUM -> "accuracy_medium"
            SensorManager.SENSOR_STATUS_ACCURACY_HIGH -> "accuracy_high"
            else -> "unknown"
        }
        eventSink?.success(status)
    }
}
