"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bufferIsUtf8 = bufferIsUtf8;
/** Characters outside the UTF8 range, if matched the file is likely binary */
var NON_UTF8_PATTERN = /[^\u0000-\u007F]/;
/** Estimate if the buffer content is text-based */
function bufferIsUtf8(buffer) {
    return NON_UTF8_PATTERN.test(buffer.toString());
}
//# sourceMappingURL=buffer.js.map